package com.bringspring.system.msgcenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.system.msgcenter.entity.McMsgTemplateFieldEntity;
import com.bringspring.system.msgcenter.mapper.McMsgTemplateFieldMapper;
import com.bringspring.system.msgcenter.model.mcmsgtemplatefield.McMsgTemplateFieldModel;
import com.bringspring.system.msgcenter.service.McMsgTemplateFieldService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.bringspring.system.msgcenter.constant.Constants.Uniqueness;

/**
 * mc_msg_template_field
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-07
 */
@Service
public class McMsgTemplateFieldServiceImpl extends ServiceImpl<McMsgTemplateFieldMapper, McMsgTemplateFieldEntity> implements McMsgTemplateFieldService {

    @Override
    public boolean checkThirdFieldUnique(List<McMsgTemplateFieldModel> fieldList) {
        // 变量
        List<String> uniqueList =
                fieldList.stream().collect(Collectors.groupingBy(McMsgTemplateFieldModel::getThirdField,
                        Collectors.counting())).entrySet().stream().filter(e -> e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        uniqueList.forEach(p -> System.out.println(p));
        // 参数
        List<String> uniqueKeywordCodeList =
                fieldList.stream().collect(Collectors.groupingBy(McMsgTemplateFieldModel::getKeywordCode,
                        Collectors.counting())).entrySet().stream().filter(e -> e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        uniqueKeywordCodeList.forEach(p -> System.out.println(p));

        if (CollectionUtil.isNotEmpty(uniqueList) || CollectionUtil.isNotEmpty(uniqueKeywordCodeList)) {
            // 存在重复编码,返回false
            return Uniqueness.NOT_UNIQUE;
        }
        return Uniqueness.UNIQUE;
    }


}