package com.bringspring.system.permission.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bringspring.system.permission.entity.UserEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * 用户信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
public interface UserMapper extends BaseMapper<UserEntity> {
    /**
     * 通过组织id获取用户信息
     *
     * @param orgId
     * @param orgIdList
     * @return
     */
    List<String> query(@Param("orgId") String orgId, @Param("orgIdList") List<String> orgIdList, @Param("account") String account, @Param("enabledMark") String enabledMark, @Param("deleteMark") String deleteMark,@Param("userRelationIdList") List<String> userRelationIdList,@Param("userManager") String userManager);

    List<String> query(@Param("orgId") String orgId, @Param("orgIdList") List<String> orgIdList, @Param("account") String account, @Param("enabledMark") String enabledMark, @Param("deleteMark") String deleteMark);

    List<String> queryByCompany(@Param("orgId") String orgId, @Param("orgIdList") List<String> orgIdList, @Param("account") String account, @Param("enabledMark") String enabledMark, @Param("deleteMark") String deleteMark);

    /**
     * 通过组织id获取用户信息(SQLServer)
     *
     * @param orgId
     * @param orgIdList
     * @return
     */
    List<String> queryKingbase(@Param("orgId") String orgId, @Param("orgIdList") List<String> orgIdList, @Param("account") String account, @Param("dbSchema") String dbSchema, @Param("enabledMark") String enabledMark, @Param("deleteMark") String deleteMark);

    /**
     * 通过组织id获取用户信息(SQLServer)
     *
     * @param orgId
     * @param orgIdList
     * @return
     */
    List<String> queryOracle(@Param("orgId") String orgId, @Param("orgIdList") List<String> orgIdList, @Param("account") String account, @Param("enabledMark") String enabledMark, @Param("deleteMark") String deleteMark);

    /**
     * 通过组织id获取用户信息(SQLServer)
     *
     * @param orgId
     * @param orgIdList
     * @return
     */
    List<String> queryDm(@Param("orgId") String orgId, @Param("orgIdList") List<String> orgIdList, @Param("account") String account, @Param("dbSchema") String dbSchema, @Param("enabledMark") String enabledMark, @Param("deleteMark") String deleteMark);
}
