package com.bringspring.system.permission.model.organize;

import com.alibaba.fastjson.annotation.JSONField;
import com.bringspring.common.util.treeutil.SumTree;
import lombok.Data;


@Data
public class OrganizeModel extends SumTree {
    /**
     * 主键
     */
    private String id;
    /**
     * 组织名称
     */
    private String fullName;
    /**
     * 简称
     */
    private String shortName;
    /**
     * 编码
     */
    private String enCode;
    /**
     * 部门主管
     */
    private String managerId;
    /**
     * 父级组织
     */
    private String organizeIdTree;
    /**
     * 部门描述
     */
    private String description;
    /**
     * 状态
     */
    private int enabledMark;
    /**
     * 图标
     */
    private String icon;
    /**
     * 组织标识（部门：department\公司：company）
     */
    @JSONField(name="category")
    private String  type;
    /**
     * 排序码
     */
    private long sortCode;
    /**
     * 创建时间
     */
    private Long creatorTime;
}
