package com.bringspring.system.permission.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.permission.entity.OrganizeAdministratorEntity;

import java.util.List;

/**
 * 机构分级管理员
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
public interface OrganizeAdministratorService extends IService<OrganizeAdministratorEntity> {


    /**
     * 获取 机构分级管理员信息
     *
     * @param userId
     * @param organizeId
     * @return
     */
    OrganizeAdministratorEntity getOne(String userId, String organizeId);

    /**
     * 根据userId获取列表
     *
     * @param userId
     * @return
     */
    List<OrganizeAdministratorEntity> getOrganizeAdministratorEntity(String userId);

    /**
     * 新建
     *
     * @param entity 实体对象
     */
    void create(OrganizeAdministratorEntity entity);

    /**
     * 更新
     *
     * @param id     主键值
     * @param entity 实体对象
     */
    boolean update(String id, OrganizeAdministratorEntity entity);

    /**
     * 删除
     *
     * @param entity 实体对象
     */
    void delete(OrganizeAdministratorEntity entity);

    /**
     * 获取 OrganizeAdminIsTratorEntity 信息
     *
     * @param id 主键值
     * @return
     */
    OrganizeAdministratorEntity getInfo(String id);

    /**
     * 获取 OrganizeAdminIsTratorEntity 信息
     *
     * @param organizeId 机构主键值
     * @return
     */
    OrganizeAdministratorEntity getInfoByOrganizeId(String organizeId);
}
