package com.bringspring.system.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.entity.OrganizeAdministratorEntity;
import com.bringspring.system.permission.mapper.OrganizeAdminIsTratorMapper;
import com.bringspring.system.permission.service.OrganizeAdministratorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 机构分级管理员
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Service
public class OrganizeAdministratorServiceImpl extends ServiceImpl<OrganizeAdminIsTratorMapper,
        OrganizeAdministratorEntity> implements OrganizeAdministratorService {

    @Autowired
    private UserProvider userProvider;


    @Override
    public OrganizeAdministratorEntity getOne(String userId, String organizeId) {
        QueryWrapper<OrganizeAdministratorEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().like(OrganizeAdministratorEntity::getUserId, userId);
        queryWrapper.lambda().eq(OrganizeAdministratorEntity::getOrganizeId, organizeId);
        // 排序
        queryWrapper.lambda().orderByAsc(OrganizeAdministratorEntity::getSortCode)
                .orderByDesc(OrganizeAdministratorEntity::getCreatorTime);
        return this.getOne(queryWrapper);
    }

    @Override
    public List<OrganizeAdministratorEntity> getOrganizeAdministratorEntity(String userId) {
        QueryWrapper<OrganizeAdministratorEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().like(OrganizeAdministratorEntity::getUserId, userId);
        // 排序
        queryWrapper.lambda().orderByAsc(OrganizeAdministratorEntity::getSortCode)
                .orderByDesc(OrganizeAdministratorEntity::getCreatorTime);
        List<OrganizeAdministratorEntity> list = this.list(queryWrapper);
        return list;
    }

    @Override
    public void create(OrganizeAdministratorEntity entity) {
        QueryWrapper<OrganizeAdministratorEntity> queryWrapper = new QueryWrapper<>();
        entity.setCreatorUserId(userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public boolean update(String organizeId, OrganizeAdministratorEntity entity) {
        entity.setId(entity.getId());
        entity.setLastModifyTime(DateUtil.getNowDate());
        entity.setLastModifyUserId(userProvider.get().getUserId());
//        queryWrapper.lambda().eq(OrganizeAdminIsTratorEntity::getOrganizeId, organizeId);
        return this.updateById(entity);
    }

    @Override
    public OrganizeAdministratorEntity getInfo(String id) {
        QueryWrapper<OrganizeAdministratorEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(OrganizeAdministratorEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void delete(OrganizeAdministratorEntity entity) {
        this.removeById(entity.getId());
    }

    @Override
    public OrganizeAdministratorEntity getInfoByOrganizeId(String organizeId) {
        QueryWrapper<OrganizeAdministratorEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(OrganizeAdministratorEntity::getOrganizeId, organizeId);
        return this.getOne(queryWrapper);
    }

}
