/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.mapper.DictionaryTypeMapper;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DictionaryTypeServiceImpl
extends ServiceImpl<DictionaryTypeMapper, DictionaryTypeEntity>
implements DictionaryTypeService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DictionaryDataService dictionaryDataService;

    @Override
    @Cacheable(value={"DictionaryTypeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<DictionaryTypeEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(DictionaryTypeEntity::getSortCode)).orderByDesc(DictionaryTypeEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"DictionaryTypeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<DictionaryTypeEntity> getListByIdList(List<String> idList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(DictionaryTypeEntity::getId, idList);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(DictionaryTypeEntity::getSortCode)).orderByDesc(DictionaryTypeEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"DictionaryTypeCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public DictionaryTypeEntity getInfoByEnCode(String enCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DictionaryTypeEntity::getEnCode, (Object)enCode);
        return (DictionaryTypeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"DictionaryTypeCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public DictionaryTypeEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DictionaryTypeEntity::getId, (Object)id);
        return (DictionaryTypeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"DictionaryTypeCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DictionaryTypeEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(DictionaryTypeEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    @Cacheable(value={"DictionaryTypeCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DictionaryTypeEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(DictionaryTypeEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    @CacheEvict(value={"DictionaryTypeCache"}, allEntries=true)
    public void create(DictionaryTypeEntity entity) {
        if (StringUtils.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtil.uuId());
            entity.setCreatorUserId(this.userProvider.get().getUserId());
        }
        this.save(entity);
    }

    @Override
    @CacheEvict(value={"DictionaryTypeCache"}, allEntries=true)
    public boolean update(String id, DictionaryTypeEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    @CacheEvict(value={"DictionaryTypeCache"}, allEntries=true)
    public boolean delete(DictionaryTypeEntity entity) {
        List dictionaryTypeEntityList = this.list().stream().filter(t -> entity.getId().equals(t.getParentId())).collect(Collectors.toList());
        if (dictionaryTypeEntityList.size() == 0 && this.dictionaryDataService.getList(entity.getId()).size() == 0) {
            this.removeById((Serializable)((Object)entity.getId()));
            return true;
        }
        return false;
    }

    @Override
    @DSTransactional
    public boolean first(String id) {
        boolean isOk = false;
        DictionaryTypeEntity upEntity = (DictionaryTypeEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = upEntity.getSortCode() == null ? 0L : upEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().lt(DictionaryTypeEntity::getSortCode, (Object)upSortCode)).eq(DictionaryTypeEntity::getParentId, (Object)upEntity.getParentId())).orderByDesc(DictionaryTypeEntity::getSortCode);
        List downEntity = this.list((Wrapper)queryWrapper);
        if (downEntity.size() > 0) {
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(((DictionaryTypeEntity)downEntity.get(0)).getSortCode());
            ((DictionaryTypeEntity)downEntity.get(0)).setSortCode(temp);
            this.updateById(downEntity.get(0));
            this.updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    @DSTransactional
    public boolean next(String id) {
        boolean isOk = false;
        DictionaryTypeEntity downEntity = (DictionaryTypeEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = downEntity.getSortCode() == null ? 0L : downEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().gt(DictionaryTypeEntity::getSortCode, (Object)upSortCode)).eq(DictionaryTypeEntity::getParentId, (Object)downEntity.getParentId())).orderByAsc(DictionaryTypeEntity::getSortCode);
        List upEntity = this.list((Wrapper)queryWrapper);
        if (upEntity.size() > 0) {
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(((DictionaryTypeEntity)upEntity.get(0)).getSortCode());
            ((DictionaryTypeEntity)upEntity.get(0)).setSortCode(temp);
            this.updateById(upEntity.get(0));
            this.updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }
}

