/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.task;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.listener.DIngStream;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.bean.WxCpDepartTreeNode;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.service.WxCpCorpService;
import com.bringspring.system.external.util.WxCpCorpValidateUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import me.chanjar.weixin.cp.api.WxCpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SyncWxCpOraginazeTask {
    private static final Logger logger = LoggerFactory.getLogger(SyncWxCpOraginazeTask.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private DIngStream dIngStream;
    @Autowired
    WxCpConfiguration wxCpConfiguration;
    @Autowired
    WxCpCorpValidateUtil wxCpCorpValidateUtil;
    @Autowired
    private WxCpCorpService wxCpCorpService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;

    @JsbosTask(fullName="\u540c\u6b65\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u4fe1\u606f", description="\u540c\u6b65\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u4fe1\u606f")
    public void syncWxCpUserList() throws BaseException {
        SysConfigEntity weComInfo = this.sysConfigService.getConfigByKeyName("weCom");
        if (ObjectUtil.isNotEmpty((Object)weComInfo) && StringUtils.isNotEmpty((String)weComInfo.getKeyValue())) {
            String keyValue = weComInfo.getKeyValue();
            List listModel = JsonUtil.getJsonToList((String)keyValue, WeComModel.class);
            if (CollectionUtil.isNotEmpty((Collection)listModel)) {
                List accountIds = listModel.stream().map(item -> item.getAccountConfigId()).collect(Collectors.toList());
                List mcMsgAccountEntities = this.mcMsgAccountService.listByIds(accountIds);
                listModel.forEach(item -> {
                    WeComModel weComModel = new WeComModel();
                    CopyOptions options = CopyOptions.create().setIgnoreProperties(new String[]{"qyhCorpSecret", "qyhAgentSecret", "token", "encodingAESKey"});
                    BeanUtil.copyProperties((Object)item, (Object)weComModel, (CopyOptions)options);
                    mcMsgAccountEntities.stream().filter(mc -> mc.getId().equals(item.getAccountConfigId())).findFirst().ifPresent(mc -> {
                        item.setQyhCorpId(mc.getEnterpriseId());
                        item.setQyhAgentId(mc.getAgentId());
                    });
                });
            }
            for (WeComModel weComModel : listModel) {
                WxCpService wxCpService = this.wxCpConfiguration.getCpService(weComModel.getQyhCorpId(), Integer.parseInt(weComModel.getQyhAgentId()));
                if (wxCpService == null) {
                    logger.error(String.format("\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%s]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", weComModel.getQyhCorpId(), weComModel.getQyhAgentId()));
                }
                try {
                    Long departId = 1L;
                    boolean fetchChild = true;
                    Integer status = 0;
                    List users = wxCpService.getUserService().listByDepartment(departId, Boolean.valueOf(fetchChild), status);
                    if (users == null || users.size() == 0) {
                        logger.error("\u4f01\u4e1a\u5fae\u4fe1\u901a\u8baf\u5f55\u5458\u5de5\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    this.wxCpCorpService.saveOrUpdateUserList(users, wxCpService);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @JsbosTask(fullName="\u540c\u6b65\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u4fe1\u606f", description="\u540c\u6b65\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u4fe1\u606f")
    public void syncWxCpDepartmentList() throws BaseException {
        SysConfigEntity weComInfo = this.sysConfigService.getConfigByKeyName("weCom");
        if (ObjectUtil.isNotEmpty((Object)weComInfo) && StringUtils.isNotEmpty((String)weComInfo.getKeyValue())) {
            String keyValue = weComInfo.getKeyValue();
            List listModel = JsonUtil.getJsonToList((String)keyValue, WeComModel.class);
            if (CollectionUtil.isNotEmpty((Collection)listModel)) {
                List accountIds = listModel.stream().map(item -> item.getAccountConfigId()).collect(Collectors.toList());
                List mcMsgAccountEntities = this.mcMsgAccountService.listByIds(accountIds);
                listModel.forEach(item -> {
                    WeComModel weComModel = new WeComModel();
                    CopyOptions options = CopyOptions.create().setIgnoreProperties(new String[]{"qyhCorpSecret", "qyhAgentSecret", "token", "encodingAESKey"});
                    BeanUtil.copyProperties((Object)item, (Object)weComModel, (CopyOptions)options);
                    mcMsgAccountEntities.stream().filter(mc -> mc.getId().equals(item.getAccountConfigId())).findFirst().ifPresent(mc -> {
                        item.setQyhCorpId(mc.getEnterpriseId());
                        item.setQyhAgentId(mc.getAgentId());
                    });
                });
            }
            for (WeComModel weComModel : listModel) {
                WxCpService wxCpService = this.wxCpConfiguration.getCpService(weComModel.getQyhCorpId(), Integer.parseInt(weComModel.getQyhAgentId()));
                if (wxCpService == null) {
                    logger.error(String.format("\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%s]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", weComModel.getQyhCorpId(), weComModel.getQyhAgentId()));
                }
                try {
                    List departList = wxCpService.getDepartmentService().list(null);
                    if (departList == null || departList.size() == 0) {
                        logger.error("\u4f01\u4e1a\u5fae\u4fe1\u901a\u8baf\u5f55\u90e8\u95e8\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    Long parentid = 0L;
                    SynThirdInfoEntity parentThird = null;
                    if (StringUtils.isNotEmpty((String)weComModel.getOrgParent()) && ObjectUtil.isNotEmpty((Object)(parentThird = this.synThirdInfoService.getInfoBySysObjId("1", "1", weComModel.getOrgParent()))) && StringUtils.isNotEmpty((String)parentThird.getThirdObjectId())) {
                        parentid = Long.valueOf(parentThird.getThirdObjectId());
                    }
                    List treeList = JsonUtil.getJsonToList((Object)departList, WxCpDepartTreeNode.class);
                    List<WxCpDepartTreeNode> wxCpDepartTreeNodes = this.wxCpCorpService.deptListToTree(treeList, parentid);
                    this.wxCpCorpService.saveOrUpdateOrganizeList(wxCpDepartTreeNodes, weComModel.getQyhCorpId(), parentThird);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

