/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.controller;

import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.message.entity.MessageEntity;
import com.bringspring.system.message.entity.MessageReceiveEntity;
import com.bringspring.system.message.model.message.MessageInfoVO;
import com.bringspring.system.message.model.message.MessageNoticeVO;
import com.bringspring.system.message.model.message.MessageRecordForm;
import com.bringspring.system.message.model.message.NoticeCrForm;
import com.bringspring.system.message.model.message.NoticeInfoVO;
import com.bringspring.system.message.model.message.NoticePagination;
import com.bringspring.system.message.model.message.NoticeUpForm;
import com.bringspring.system.message.model.message.PaginationMessage;
import com.bringspring.system.message.service.MessageService;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SentMessageUtil;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.RangeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7cfb\u7edf\u516c\u544a"}, value="Message")
@RestController
@RequestMapping(value={"/api/message"})
public class MessageController {
    private static final Logger log = LoggerFactory.getLogger(MessageController.class);
    @Autowired
    private MessageService messageService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private SentMessageUtil sentMessageUtil;
    @Autowired
    private RangeService rangeService;

    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u516c\u544a\u5217\u8868\uff08\u5e26\u5206\u9875\uff09")
    @GetMapping(value={"/Notice"})
    public ActionResult<PageListVO<MessageNoticeVO>> noticeList(NoticePagination pagination) {
        List<MessageEntity> list = this.messageService.getNoticeList(pagination);
        List<UserEntity> userList = this.userService.getUserName(list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        for (MessageEntity entity : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(entity.getCreatorUserId())).findFirst().orElse(null);
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        List voList = JsonUtil.getJsonToList(list, MessageNoticeVO.class);
        return ActionResult.page((List)voList, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u6dfb\u52a0\u7cfb\u7edf\u516c\u544a")
    @PostMapping
    public ActionResult create(@RequestBody @Valid NoticeCrForm noticeCrForm) {
        MessageEntity entity = (MessageEntity)JsonUtil.getJsonToBean((Object)noticeCrForm, MessageEntity.class);
        String sendRange = entity.getSendRange();
        if ("user".equals(entity.getSendType())) {
            List<UserEntity> rangeUserList = this.rangeService.getRangeUserList(sendRange);
            List ids = rangeUserList.stream().map(UserEntity::getId).collect(Collectors.toList());
            entity.setToUserIds(String.join((CharSequence)",", ids));
        }
        this.messageService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u4fee\u6539\u7cfb\u7edf\u516c\u544a")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid NoticeUpForm messageUpForm) {
        boolean flag;
        MessageEntity entity = (MessageEntity)JsonUtil.getJsonToBean((Object)messageUpForm, MessageEntity.class);
        String sendRange = entity.getSendRange();
        if ("user".equals(entity.getSendType())) {
            List<UserEntity> rangeUserList = this.rangeService.getRangeUserList(sendRange);
            List ids = rangeUserList.stream().map(UserEntity::getId).collect(Collectors.toList());
            entity.setToUserIds(String.join((CharSequence)",", ids));
        }
        if (!(flag = this.messageService.update(id, entity))) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u83b7\u53d6/\u67e5\u770b\u7cfb\u7edf\u516c\u544a\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<NoticeInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        MessageEntity entity;
        UserEntity info = this.userService.getInfo((entity = this.messageService.getinfo(id)).getCreatorUserId());
        entity.setCreatorUserId(info != null ? info.getRealName() : "");
        NoticeInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, NoticeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5220\u9664\u7cfb\u7edf\u516c\u544a")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        MessageEntity entity = this.messageService.getinfo(id);
        if (entity != null) {
            this.messageService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u53d1\u5e03\u7cfb\u7edf\u516c\u544a")
    @Transactional
    @PutMapping(value={"/{id}/Actions/Release"})
    public ActionResult release(@PathVariable(value="id") String id) throws BaseException {
        MessageEntity entity = this.messageService.getinfo(id);
        UserInfo userInfo = this.userProvider.get();
        if (entity != null) {
            ArrayList<String> userIds = new ArrayList<String>();
            switch (entity.getSendType()) {
                case "user": {
                    if (StringUtil.isNotEmpty((String)entity.getToUserIds())) {
                        userIds.addAll(Arrays.asList(entity.getToUserIds().split(",")));
                        break;
                    }
                    userIds.addAll(this.userService.getListId());
                    break;
                }
            }
            String content = "\u6807\u9898\uff1a" + entity.getTitle();
            String title = "\u53d1\u6587\uff1a\u6709\u65b0\u6536\u5230\u7684\u516c\u544a\u7b49\u5f85\u60a8\u7684\u9605\u8bfb\u3002";
            String appurl = "/#/pages/notice/index?id=" + entity.getId() + "&msg_id=" + entity.getId() + "&type=1";
            String pcurl = "/#/basic/messageRecord?id=" + entity.getId() + "&msg_id=" + entity.getId() + "&type=1";
            if (entity.getSendType().equals("@ALL")) {
                this.messageService.newSendMessage("\u516c\u544a", "noticeMessage", title, content, appurl, pcurl, userIds, "@ALL");
            } else {
                this.messageService.newSendMessage("\u516c\u544a", "noticeMessage", title, content, appurl, pcurl, userIds, "user");
            }
            entity.setEnabledMark(1);
            entity.setLastModifyTime(new Date());
            entity.setLastModifyUserId(userInfo.getUserId());
            this.messageService.updateById(entity);
            return ActionResult.success((String)"\u53d1\u5e03\u6210\u529f");
        }
        return ActionResult.fail((String)"\u53d1\u5e03\u5931\u8d25");
    }

    @ApiOperation(value="\u5217\u8868\uff08\u901a\u77e5\u516c\u544a/\u7cfb\u7edf\u6d88\u606f/\u79c1\u4fe1\u6d88\u606f\uff09")
    @GetMapping
    public ActionResult<PageListVO<MessageInfoVO>> messageList(PaginationMessage pagination) {
        List<MessageEntity> list = this.messageService.getMessageList(pagination, pagination.getType(), pagination.getAppid(), pagination.getIsShowRead());
        List<UserEntity> userList = this.userService.getUserName(list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        for (MessageEntity entity : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(entity.getCreatorUserId())).findFirst().orElse(null);
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
        }
        List listVO = JsonUtil.getJsonToList(list, MessageInfoVO.class);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u53ea\u83b7\u53d6\u516c\u544a\u6d88\u606f\u5217\u8868")
    @GetMapping(value={"/getNoticeListByType"})
    public ActionResult<PageListVO<MessageInfoVO>> getNoticeListByType(PaginationMessage pagination) {
        List<MessageEntity> list = this.messageService.getNoticeListByType(pagination, pagination.getType());
        List<UserEntity> userList = this.userService.getUserName(list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        for (MessageEntity entity : list) {
            UserEntity user = userList.stream().filter(t -> t.getId().equals(entity.getCreatorUserId())).findFirst().orElse(null);
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
        }
        List listVO = JsonUtil.getJsonToList(list, MessageInfoVO.class);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u5217\u8868\uff08\u901a\u77e5\u516c\u544a/\u7cfb\u7edf\u6d88\u606f/\u79c1\u4fe1\u6d88\u606f\uff09")
    @PostMapping(value={"/getUnreadCount"})
    public ActionResult<Integer> getUnreadCount(String userId) {
        int unreadCount = this.messageService.getUnreadCount(userId);
        return ActionResult.success((Object)unreadCount);
    }

    @ApiOperation(value="\u8bfb\u53d6\u6d88\u606f")
    @NotCheckLogin
    @GetMapping(value={"/ReadInfo/{id}"})
    public ActionResult readInfo(@PathVariable(value="id") String id) throws DataException {
        MessageEntity entity = this.messageService.getinfo(id);
        String bodyText = entity.getBodyText();
        if (entity != null) {
            MessageReceiveEntity receive = this.messageService.messageRead(id);
            UserEntity user = this.userService.getInfo(entity.getCreatorUserId());
            entity.setCreatorUserId(user != null ? user.getRealName() : "");
            entity.setBodyText(receive != null ? receive.getBodyText() : null);
            if (receive == null) {
                entity.setBodyText(bodyText);
            }
        }
        NoticeInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, NoticeInfoVO.class);
        MessageEntity getinfo = this.messageService.getinfo(id);
        getinfo.setIsRead(1);
        getinfo.setLastModifyTime(getinfo.getLastModifyTime());
        this.messageService.updateById(getinfo);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5168\u90e8\u5df2\u8bfb")
    @PostMapping(value={"/Actions/ReadAll"})
    public ActionResult allRead() {
        this.messageService.messageRead();
        return ActionResult.success((String)"\u5df2\u8bfb\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664\u6d88\u606f")
    @DeleteMapping(value={"/Record"})
    public ActionResult deleteRecord(@RequestBody MessageRecordForm recordForm) {
        String[] id = recordForm.getIds().split(",");
        List<String> list = Arrays.asList(id);
        this.messageService.deleteRecord(list);
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    private Map<String, String> getSystemConfig() {
        List<SysConfigEntity> configList = this.sysConfigService.getList();
        HashMap<String, String> objModel = new HashMap<String, String>(16);
        for (SysConfigEntity entity : configList) {
            objModel.put(entity.getKeyName(), entity.getKeyValue());
        }
        return objModel;
    }

    private List<List<String>> splitList(List<String> messagesList, int groupSize) {
        int length = messagesList.size();
        int num = (length + groupSize - 1) / groupSize;
        ArrayList<List<String>> newList = new ArrayList<List<String>>(num);
        for (int i = 0; i < num; ++i) {
            int fromIndex = i * groupSize;
            int toIndex = (i + 1) * groupSize < length ? (i + 1) * groupSize : length;
            newList.add(messagesList.subList(fromIndex, toIndex));
        }
        return newList;
    }
}

