/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.chain;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.enums.MsgCenterCode;
import com.bringspring.system.msgcenter.service.chain.FilterProcessor;
import com.bringspring.system.msgcenter.service.context.FilterResult;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ReceiveUserFilter
implements FilterProcessor {
    @Override
    public FilterResult process(SendMessageContext context) {
        Map<Boolean, List<McTaskMsgReceiveEntity>> partitioned = context.getValidList().stream().collect(Collectors.partitioningBy(r -> StringUtils.isNotEmpty((String)r.getReceiveUserId())));
        List<McTaskMsgReceiveEntity> invalidList = partitioned.get(false);
        if (CollectionUtil.isNotEmpty(invalidList)) {
            invalidList.stream().forEach(e -> {
                e.setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                e.setDescription(MsgCenterCode.RECEIVER_ID_EMPTY.getDesc() + "\uff0c\u8bf7\u68c0\u67e5\u63a5\u6536\u4eba\u662f\u5426\u4e3a\u7a7a\u3002");
            });
        }
        return new FilterResult(partitioned.get(true), invalidList);
    }
}

