/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.factory;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.system.msgcenter.exception.SendMessageException;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageSender;
import com.bringspring.system.msgcenter.service.strategy.MessageSender;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageSenderFactory {
    private static final Logger log = LoggerFactory.getLogger(MessageSenderFactory.class);
    private final Map<String, AbstractMessageSender> strategies;

    @Autowired
    public MessageSenderFactory(List<AbstractMessageSender> senders) {
        this.strategies = senders.stream().collect(Collectors.toMap(s -> s.getChannelType().getCode(), Function.identity(), (existing, replacement) -> {
            log.warn("\u91cd\u590d\u7684\u6e20\u9053\u7c7b\u578b: {}", (Object)existing.getChannelType());
            return existing;
        }));
    }

    public MessageSender getSender(String channelType) {
        MessageSender sender = this.strategies.get(channelType);
        if (ObjectUtil.isNull((Object)sender)) {
            throw new SendMessageException(2, "\u4e0d\u652f\u6301\u7684\u6e20\u9053\u7c7b\u578b: " + channelType, null);
        }
        return sender;
    }
}

