/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.impl;

import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.msgcenter.constant.Constants;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemStrategy
extends AbstractMessageChannelStrategy {
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private UserService userService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.SYS_MSG;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg, McMsgSendTemplateModel sendTemplate, Map<String, McTaskMsgContentEntity> contentMap, Map<String, List<McTaskMsgReceiveEntity>> receiveMap, Set<String> userSet) {
        McTaskMsgContentEntity sysContent;
        String taskMsgId = taskMsg.getId();
        String templateId = sendTemplate.getId();
        String channelType = sendTemplate.getMessageType();
        String msgTemplateId = sendTemplate.getTemplateId();
        String msgAccountId = sendTemplate.getAccountConfigId();
        McMsgAccountEntity account = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        McMsgTemplateEntity msgTemplate = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        String sysKey = channelType + msgTemplateId;
        if (!contentMap.containsKey(sysKey)) {
            sysContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(sysKey, sysContent);
        } else {
            sysContent = contentMap.get(sysKey);
        }
        if (!receiveMap.containsKey(sysKey) && !"4".equals(taskMsg.getToType())) {
            ArrayList sysReceiveList = new ArrayList();
            List<UserEntity> receiveUsers = this.userService.getUserByIds(new ArrayList<String>(userSet));
            receiveUsers.stream().forEach(s -> {
                McTaskMsgReceiveEntity receiveEntity = new McTaskMsgReceiveEntity();
                receiveEntity.setId(RandomUtil.uuId());
                receiveEntity.setMsgId(taskMsgId);
                receiveEntity.setTemplateId(templateId);
                receiveEntity.setMsgTemplateId(msgTemplateId);
                receiveEntity.setMsgAccountId(msgAccountId);
                receiveEntity.setContentId(sysContent.getId());
                receiveEntity.setChannelType(channelType);
                receiveEntity.setReceiveUserId(s.getId());
                receiveEntity.setSysUserId(s.getId());
                receiveEntity.setEnabledMark(0);
                receiveEntity.setIsRead(Constants.ReadStatus.UNREAD.getCode());
                receiveEntity.setDescription(null);
                sysReceiveList.add(receiveEntity);
            });
            receiveMap.put(sysKey, sysReceiveList);
        }
    }
}

