package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 *
 * 表单权限
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2021-09-14
 */
@Data
@TableName("BASE_MODULE_FORM")
public class ModuleFormEntity {
    /**
     * 表单主键
     */
    @TableId("ID")
    private String id;

    /**
     * 表单上级
     */
    @TableField("PARENT_ID")
    private String parentId;

    /**
     * 表单名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 表单编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 扩展属性
     */
    @TableField("PROPERTY_JSON")
    private String propertyJson;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 功能主键
     */
    @TableField("MODULE_ID")
    private String moduleId;

    /**
     * 字段规则 主从
     */
    @TableField("FIELD_RULE")
    private Integer fieldRule;

    /**
     * 绑定表格Id
     */
    @TableField("BIND_TABLE")
    private String bindTable;
    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

}
