package com.bringspring.system.base.model.province;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 行政区划
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-12-11
 */
@Data
public class ProvinceSelector {
    @ApiModelProperty(value = "主键")
    private String id;
    @ApiModelProperty(value = "父主键")
    private String parentId;
    @ApiModelProperty(value = "编码")
    private String enCode;
    @ApiModelProperty(value = "名称")
    private String fullName;
    @ApiModelProperty(value = "快速查询")
    private String quickQuery;
    @ApiModelProperty(value = "区域类型")
    private String type;
    @ApiModelProperty(value = "城市级别")
    private Integer cityLevel;
    @ApiModelProperty(value = "简称")
    private String provSimpleName;
    @ApiModelProperty(value = "祖宗ids")
    private String parentIdTree;
    @ApiModelProperty(value = "描述")
    private String description;
    @ApiModelProperty(value = "图标")
    private String icon;
    @ApiModelProperty(value = "是否可用")
    private Integer enabledMark;
    @ApiModelProperty(value = "是否有下级")
    private Boolean hasChildren;
    @ApiModelProperty(value = "下级列表")
    private List<ProvinceSelector> children;
}
