package com.bringspring.system.base.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.model.UserLogForm;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.model.BurialPoint.VisitVO;
import com.bringspring.system.base.model.logs.LoginUserStatistics;
import com.bringspring.system.base.model.logs.LoginUserStatisticsQuery;
import com.bringspring.system.base.model.logs.PaginationLogModel;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 系统日志
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
public interface LogService extends IService<LogEntity> {

    /**
     * 列表
     *
     * @param userLogForm
     * @return
     */
    List<LogEntity> getList(UserLogForm userLogForm);

    /**
     * 列表
     *
     * @param category       日志分类
     * @param paginationTime 分页条件
     * @return
     */
    List<LogEntity> getList(int category, PaginationLogModel paginationTime);

    /**
     * 信息
     *
     * @param id 主键值
     * @return
     */
    LogEntity getInfo(String id);


    /**
     * 删除
     *
     * @param ids
     * @return
     */
    boolean delete(String[] ids);

    /**
     * 写入日志
     *
     * @param userId    用户Id
     * @param userName  用户名称
     * @param abstracts 摘要
     */
    void writeLogAsync(String userId, String userName, String abstracts);

    /**
     * 请求日志
     *
     * @param logEntity 实体对象
     */
    void writeLogAsync(LogEntity logEntity);

    /**
     * 请求日志
     */
    void deleteHandleLog(String type);

    /**
     * 自动删除请求日志
     */
    void autoDeleteLog();

    /**
     * 获取操作模块名
     *
     * @return
     */
    Set<String> queryList();

    /**
     * 根据请求日志统计近30分钟内，每分钟上，访问请求所属用户的用户数量
     *
     * @return 结果
     */
    List<Map<String, Object>> selectUserGroupByCreatorTime(String category, PaginationLogModel logModel);

    /**
     * 根据请求日志统计近30分钟内，每分钟上，访问请求所属模块的模块数量
     *
     * @return 结果
     */
    List<Map<String, Object>> selectModuleGroupByCreatorTime(String category, PaginationLogModel logModel);

    /**
     * 根据请求日志统计近30分钟内，每分钟上，访问请求数量
     *
     * @return 结果
     */
    List<Map<String, Object>> selectGroupByCreatorTime(String category, PaginationLogModel logModel);

    /**
     * 根据请求日志统计近30分钟内，每分钟上，混合数据
     *
     * @return 结果
     */
    List<Map<String, Object>> selectMixedGroupByCreatorTime(String category, PaginationLogModel logModel);

    /**
     * 根据请求日志统计近30分钟内，功能模块的请求量
     *
     * @return 结果
     */
    List<Map<String, Object>> selectGroupByModule(String category, PaginationLogModel logModel);

    /**
     * 用户访问功能次数（每分钟算一次）
     *
     * @return 结果
     */
    List<VisitVO> userVisit(VisitVO visitVO);

    /**
     * 功能访问次数（每分钟算一次）
     *
     * @return 结果
     */
    List<VisitVO> functionVisit(VisitVO visitVO);

    /**
     * 用户访问总次数（每分钟算一次）
     *
     * @return 结果
     */
    List<VisitVO> functionUserVisit(VisitVO visitVO);

    /**
     * 活跃用户数
     * 进行过功能操作的用户数量
     * @return 结果
     */
    List<VisitVO> functionUserCountVisit(VisitVO visitVO);

    /**
     * 功能列表
     * 时间段内使用过的功能列表
     * @return 结果
     */
    List<VisitVO> functionList(VisitVO visitVO);

    /**
     * 登录用户统计
     * @param loginUserStatisticsQuery 统计查询条件
     * @return 统计结果
     * @author RKKJ
     * @date 2021-01-11
     * @version V1.0.0
     * @copyright 荣科科技股份有限公司
     */
    LoginUserStatistics loginUserStatistics(LoginUserStatisticsQuery loginUserStatisticsQuery);
}
