package com.bringspring.system.base.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.BaseUserBsbEntity;
import com.bringspring.system.base.mapper.BaseUserBsbMapper;
import com.bringspring.system.base.model.baseuserbsb.BaseUserBsbPagination;
import com.bringspring.system.base.service.BaseUserBsbService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * 荣科币
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2023-04-04
 */
@Service
public class BaseUserBsbServiceImpl extends ServiceImpl<BaseUserBsbMapper, BaseUserBsbEntity> implements BaseUserBsbService {


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private AuthorizeService authorizeService;


    @Override
    public List<BaseUserBsbEntity> getList(BaseUserBsbPagination baseUserBsbPagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int baseUserBsbNum = 0;
        QueryWrapper<BaseUserBsbEntity> baseUserBsbQueryWrapper = new QueryWrapper<>();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader("jsbos-origin").equals("pc");
        if (isPc && pcPermission) {
            if (!userProvider.get().getIsAdministrator()) {
                Object baseUserBsbObj = authorizeService.getCondition(new AuthorizeConditionModel(baseUserBsbQueryWrapper, baseUserBsbPagination.getMenuId(), "baseUserBsb"));
                if (ObjectUtil.isEmpty(baseUserBsbObj)) {
                    return new ArrayList<>();
                } else {
                    baseUserBsbQueryWrapper = (QueryWrapper<BaseUserBsbEntity>) baseUserBsbObj;
                    baseUserBsbNum++;
                }
            }
        }
        if (!isPc && appPermission) {
            if (!userProvider.get().getIsAdministrator()) {
                Object baseUserBsbObj = authorizeService.getCondition(new AuthorizeConditionModel(baseUserBsbQueryWrapper, baseUserBsbPagination.getMenuId(), "baseUserBsb"));
                if (ObjectUtil.isEmpty(baseUserBsbObj)) {
                    return new ArrayList<>();
                } else {
                    baseUserBsbQueryWrapper = (QueryWrapper<BaseUserBsbEntity>) baseUserBsbObj;
                    baseUserBsbNum++;
                }


            }
        }
        if (StringUtils.isNotEmpty(baseUserBsbPagination.getUserId())) {
            baseUserBsbNum++;
            baseUserBsbQueryWrapper.lambda().like(BaseUserBsbEntity::getUserId, baseUserBsbPagination.getUserId());
        }

        if (StringUtils.isNotEmpty(baseUserBsbPagination.getEnabledMark())) {
            baseUserBsbNum++;
            baseUserBsbQueryWrapper.lambda().like(BaseUserBsbEntity::getEnabledMark, baseUserBsbPagination.getEnabledMark());
        }

        if (AllIdList.size() > 0) {
            baseUserBsbQueryWrapper.lambda().in(BaseUserBsbEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(baseUserBsbPagination.getSidx())) {
            baseUserBsbQueryWrapper.lambda().orderByDesc(BaseUserBsbEntity::getId);
        } else {
            try {
                String sidx = baseUserBsbPagination.getSidx();
                BaseUserBsbEntity baseUserBsbEntity = new BaseUserBsbEntity();
                Field declaredField = baseUserBsbEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                baseUserBsbQueryWrapper = "asc".equals(baseUserBsbPagination.getSort().toLowerCase()) ? baseUserBsbQueryWrapper.orderByAsc(value) : baseUserBsbQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<BaseUserBsbEntity> page = new Page<>(baseUserBsbPagination.getCurrentPage(), baseUserBsbPagination.getPageSize());
            IPage<BaseUserBsbEntity> userIPage = this.page(page, baseUserBsbQueryWrapper);
            return baseUserBsbPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<BaseUserBsbEntity> list = new ArrayList();
            return baseUserBsbPagination.setData(list, list.size());
        }
    }

    @Override
    public List<BaseUserBsbEntity> getTypeList(BaseUserBsbPagination baseUserBsbPagination, String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int baseUserBsbNum = 0;
        QueryWrapper<BaseUserBsbEntity> baseUserBsbQueryWrapper = new QueryWrapper<>();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader("jsbos-origin").equals("pc");
        if (isPc && pcPermission) {
            if (!userProvider.get().getIsAdministrator()) {
                Object baseUserBsbObj = authorizeService.getCondition(new AuthorizeConditionModel(baseUserBsbQueryWrapper, baseUserBsbPagination.getMenuId(), "baseUserBsb"));
                if (ObjectUtil.isEmpty(baseUserBsbObj)) {
                    return new ArrayList<>();
                } else {
                    baseUserBsbQueryWrapper = (QueryWrapper<BaseUserBsbEntity>) baseUserBsbObj;
                    baseUserBsbNum++;
                }
            }
        }
        if (!isPc && appPermission) {
            if (!userProvider.get().getIsAdministrator()) {
                Object baseUserBsbObj = authorizeService.getCondition(new AuthorizeConditionModel(baseUserBsbQueryWrapper, baseUserBsbPagination.getMenuId(), "baseUserBsb"));
                if (ObjectUtil.isEmpty(baseUserBsbObj)) {
                    return new ArrayList<>();
                } else {
                    baseUserBsbQueryWrapper = (QueryWrapper<BaseUserBsbEntity>) baseUserBsbObj;
                    baseUserBsbNum++;
                }


            }
        }
        if (StringUtils.isNotEmpty(baseUserBsbPagination.getUserId())) {
            baseUserBsbNum++;
            baseUserBsbQueryWrapper.lambda().like(BaseUserBsbEntity::getUserId, baseUserBsbPagination.getUserId());
        }

        if (StringUtils.isNotEmpty(baseUserBsbPagination.getEnabledMark())) {
            baseUserBsbNum++;
            baseUserBsbQueryWrapper.lambda().like(BaseUserBsbEntity::getEnabledMark, baseUserBsbPagination.getEnabledMark());
        }

        if (AllIdList.size() > 0) {
            baseUserBsbQueryWrapper.lambda().in(BaseUserBsbEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(baseUserBsbPagination.getSidx())) {
            baseUserBsbQueryWrapper.lambda().orderByDesc(BaseUserBsbEntity::getId);
        } else {
            try {
                String sidx = baseUserBsbPagination.getSidx();
                BaseUserBsbEntity baseUserBsbEntity = new BaseUserBsbEntity();
                Field declaredField = baseUserBsbEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                baseUserBsbQueryWrapper = "asc".equals(baseUserBsbPagination.getSort().toLowerCase()) ? baseUserBsbQueryWrapper.orderByAsc(value) : baseUserBsbQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<BaseUserBsbEntity> page = new Page<>(baseUserBsbPagination.getCurrentPage(), baseUserBsbPagination.getPageSize());
                IPage<BaseUserBsbEntity> userIPage = this.page(page, baseUserBsbQueryWrapper);
                return baseUserBsbPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<BaseUserBsbEntity> list = new ArrayList();
                return baseUserBsbPagination.setData(list, list.size());
            }
        } else {
            return this.list(baseUserBsbQueryWrapper);
        }
    }

    @Override
    public BaseUserBsbEntity getInfo(String id) {
        QueryWrapper<BaseUserBsbEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(BaseUserBsbEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void create(BaseUserBsbEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, BaseUserBsbEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(BaseUserBsbEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }
    //子表方法

    //列表子表数据方法


}