package com.bringspring.system.external.service;

import com.bringspring.system.external.bean.WxCpDepartTreeNode;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpUser;

import java.util.List;

/**
 * 企业相关接口
 *
 * @since 30/1/2024 9:57 PM
 */
public interface WxCpCorpService {

    List<SynThirdInfoEntity> saveOrUpdateOrganizeList(List<WxCpDepartTreeNode> treeList, String corpId,
                                                      SynThirdInfoEntity parentThird);

    void deleteOrganize(String corpId, String deptId);

    /**
     * 企业微信部门树形数据转化为本地持久化数据
     * 递归处理
     *
     * @param treeList         企业微信部门树形数据
     * @param corpId           企业微信
     * @param organizeList     本地部门数据
     * @param synThirdInfoList 第三方同步记录表数据
     */
    void wxCpDepartToOrganizeList(List<WxCpDepartTreeNode> treeList, String corpId,
                                  List<OrganizeEntity> organizeList, List<SynThirdInfoEntity> synThirdInfoList);

    /**
     * 部门列表树形结构转化
     *
     * @param departList 部门列表
     * @param parentId   父级ID
     * @return
     */
    List<WxCpDepartTreeNode> deptListToTree(List<WxCpDepartTreeNode> departList, Long parentId);


    List<UserEntity> saveOrUpdateUserList(List<WxCpUser> users, WxCpService wxCpService) throws WxErrorException;

    void deleteUser(String corpId, String userId);
}
