package com.bringspring.system.message.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 聊天内容
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("BASE_IM_CONTENT")
public class ImContentEntity {
    /**
     * 聊天主键
     */
    @TableId("ID")
    private String id;

    /**
     * 发送者
     */
    @TableField("SEND_USER_ID")
    private String sendUserId;

    /**
     * 发送时间
     */
    @TableField("SEND_TIME")
    private Date sendTime;

    /**
     * 接收者
     */
    @TableField("RECEIVE_USER_ID")
    private String receiveUserId;

    /**
     * 接收时间
     */
    @TableField("RECEIVE_TIME")
    private Date receiveTime;

    /**
     * 内容
     */
    @TableField("CONTENT")
    private String content;

    /**
     * 内容
     */
    @TableField("CONTENT_TYPE")
    private String contentType;

    /**
     * 状态
     */
    @TableField("STATE")
    private Integer state;

}
