package com.bringspring.system.message.util;

import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.enums.FileTypeEnum;
import com.bringspring.common.util.file.UploadUtil;
import org.apache.commons.codec.binary.Base64;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16 8:47
 */
public class Base64Util {

    private static ConfigValueUtil configValueUtil = SpringContext.getBean(ConfigValueUtil.class);


    /**
     * 把文件转化为base64.
     *
     * @param filePath 源文件路径
     */
    public static String fileToBase64(String filePath) {
        if (!StringUtils.isEmpty(filePath)) {
            try {
                byte[] bytes = Files.readAllBytes(Paths.get(filePath));
                return Base64.encodeBase64String(bytes);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /**
     * base64转化为文件.
     *
     * @param base64   base64
     * @param filePath 目标文件路径
     * @param fileName 文件名称
     */
    public static void base64ToFile(String base64, String filePath, String fileName) {
        try {
            Files.write(Paths.get(filePath), Base64.decodeBase64(base64), StandardOpenOption.CREATE);
            //上传到Minio
            UploadUtil.uploadFile(configValueUtil.getFileType(), filePath, FileTypeEnum.IM, fileName);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
