package com.bringspring.system.msgcenter.service.chain;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.enums.MsgCenterCode;
import com.bringspring.system.msgcenter.service.context.FilterResult;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 业务消息接收人是否有效过滤器
 * <p>
 * 此处节点针对消息中心：判断接收人第三方标识（ReceiveUserId）是否为空。
 * 注意：此处的判断条件仅仅是接收人是否为空，并不判断接收人是否存在。
 */
@Component
public class ReceiveUserFilter implements FilterProcessor {
    @Override
    public FilterResult process(SendMessageContext context) {
        /**
         *  先分组，判断接收人是否为空。
         *  注意：责任链上一个节点已经将无效的记录过滤掉了context.getValidList()
         */
        Map<Boolean, List<McTaskMsgReceiveEntity>> partitioned = context.getValidList().stream()
                .collect(Collectors.partitioningBy(r -> StringUtils.isNotEmpty(r.getReceiveUserId())));


        List<McTaskMsgReceiveEntity> invalidList = partitioned.get(false);
        if (CollectionUtil.isNotEmpty(invalidList)) {
            // 分离有效和无效记录，并标注原因
            invalidList.stream().forEach(e -> {
                e.setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                e.setDescription(MsgCenterCode.RECEIVER_ID_EMPTY.getDesc() + "，请检查接收人是否为空。");
            });
        }

        return new FilterResult(partitioned.get(true), invalidList);
    }
}
