package com.bringspring.system.permission.controller;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.model.UserLogForm;
import com.bringspring.common.util.*;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.SumTree;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.model.button.ButtonModel;
import com.bringspring.system.base.model.column.ColumnModel;
import com.bringspring.system.base.model.form.ModuleFormModel;
import com.bringspring.system.base.model.module.ModuleModel;
import com.bringspring.system.base.model.resource.ResourceModel;
import com.bringspring.system.base.service.LogService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.permission.constant.PermissionConst;
import com.bringspring.system.permission.entity.*;
import com.bringspring.system.permission.model.authorize.*;
import com.bringspring.system.permission.model.permission.PermissionModel;
import com.bringspring.system.permission.model.user.form.*;
import com.bringspring.system.permission.model.user.mod.UserAuthorizeModel;
import com.bringspring.system.permission.model.user.page.PaginationUser;
import com.bringspring.system.permission.model.user.vo.*;
import com.bringspring.system.permission.service.*;
import com.bringspring.system.permission.util.RecursiveRemovalUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.*;
import java.util.stream.Collectors;

import static com.bringspring.common.base.GlobalMarkEnum.NOT_ORGANIZE;
import static com.bringspring.common.constant.CacheConsts.LOGIN_CACHE;

/**
 * 个人资料
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Api(tags = "个人资料", value = "CurrentUsersInfo")
@RestController
@RequestMapping("/api/permission/Users/Current")
public class UserSettingController {


    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private LogService logService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private ModuleService moduleService;

    /**
     * 我的信息
     *
     * @return
     */
    @ApiOperation("个人资料")
    @GetMapping("/BaseInfo")
    public ActionResult<UserBaseInfoVO> get() {
        UserInfo userInfo = userProvider.get();
        UserEntity userEntity = userService.getInfo(userInfo.getUserId());

        String catchKey = cacheKeyUtil.getAllUser();
        if (cacheUtil.exists(catchKey)) {
            cacheUtil.remove(catchKey);
        }

        UserBaseInfoVO vo = JsonUtil.getJsonToBean(userEntity, UserBaseInfoVO.class);


        if (StringUtils.isNotEmpty(userEntity.getManagerId())) {
            UserEntity menager = userService.getInfo(userEntity.getManagerId());
            vo.setManager(menager != null ? menager.getRealName() : "");
        }

        //设置语言和主题
        vo.setLanguage(userEntity.getLanguage() != null ? userEntity.getLanguage() : "zh-CN");
        vo.setTheme(userEntity.getTheme() != null ? userEntity.getTheme() : "W-001");

        // 获取组织
        String organizeStr = userRelationService.getAllOrganizeNameInfoById(userEntity.getId());
        vo.setOrganize(organizeStr);
        if (StringUtils.isNotEmpty(userEntity.getOrganizeId())) {
            OrganizeEntity directlyUnderCompanyById =
                    organizeService.getDirectlyUnderCompanyById(userEntity.getOrganizeId());
            vo.setCompany(StringUtils.isNotEmpty(directlyUnderCompanyById.getShortName()) ?
                    directlyUnderCompanyById.getShortName() : directlyUnderCompanyById.getFullName());
        }
        // 获取角色
        if (StringUtils.isNotEmpty(userInfo.getDepartmentId())) {
            vo.setRoleId(roleService.getCurRolesByOrgId(userInfo.getDepartmentId()).stream()
                    .map(PermissionEntityBase::getFullName).collect(Collectors.joining(",")));
        }

        List<RoleEntity> listByUserId = roleService.getListByUserId(userInfo.getUserId());
        vo.setRoleEntityList(listByUserId);

        // 获取主要岗位
        List<PositionEntity> positionEntityList = positionService.getListByOrgIdAndUserId(userInfo.getDepartmentId(),
                userEntity.getId());
        if (positionEntityList.size() > 0) {
            List<String> fullNames =
                    positionEntityList.stream().map(PositionEntity::getFullName).collect(Collectors.toList());
            vo.setPosition(String.join(",", fullNames));
        }

        // 获取用户
        if (StringUtils.isNotEmpty(userInfo.getTenantId())) {
            vo.setAccount(userInfo.getTenantId() + "@" + vo.getAccount());
        }

        // 获取用户头像
        if (!StringUtils.isEmpty(userInfo.getUserIcon())) {
//            vo.setAvatar(UploaderUtil.uploaderImg(userInfo.getUserIcon()));
            vo.setAvatar(userInfo.getUserIcon());
        }
        return ActionResult.success(vo);
    }

    /**
     * 根据用户id获取用户信息
     *
     * @return
     */
    @ApiOperation("根据用户id获取用户个人资料")
    @GetMapping("/getBaseInfoById/{id}")
    public ActionResult<UserBaseInfoVO> getBaseInfoById(@PathVariable("id") String id) {
        UserEntity userEntity = userService.getInfo(id);
        UserBaseInfoVO vo = JsonUtil.getJsonToBean(userEntity, UserBaseInfoVO.class);
        if (StringUtils.isNotEmpty(userEntity.getManagerId())) {
            UserEntity menager = userService.getInfo(userEntity.getManagerId());
            vo.setManager(menager != null ? menager.getRealName() : "");
        }

        //设置语言和主题
        vo.setLanguage(userEntity.getLanguage() != null ? userEntity.getLanguage() : "zh-CN");
        vo.setTheme(userEntity.getTheme() != null ? userEntity.getTheme() : "W-001");

        // 获取组织
        String organizeStr = userRelationService.getAllOrganizeNameInfoById(userEntity.getId());

        vo.setOrganize(organizeStr);

        // 获取角色

        QueryWrapper<UserRelationEntity> roleQuery = new QueryWrapper<>();
        roleQuery.lambda().eq(UserRelationEntity::getUserId, id);
        roleQuery.lambda().eq(UserRelationEntity::getObjectType, PermissionConst.ROLE);
        List<String> roleIdList = new ArrayList<>();
        for (UserRelationEntity ure : userRelationService.list(roleQuery)) {
            roleIdList.add(ure.getObjectId());
        }

        List<RoleEntity> listByIds = roleService.getListByIds(roleIdList);
        String roleNameList = "";
        for (RoleEntity roleEntity : listByIds) {
            roleNameList += roleEntity.getFullName() + ",";
        }
        if (StringUtils.isNotEmpty(roleNameList)) {
            roleNameList = roleNameList.substring(0, roleNameList.length() - 1);
        }
        vo.setRoleId(roleNameList);
        vo.setRoleEntityList(listByIds);
        for (RoleEntity entity : vo.getRoleEntityList()) {

            if (ObjectUtil.isNotEmpty(entity) && ObjectUtil.isNotEmpty(entity.getGlobalMark()) && NOT_ORGANIZE.getCode().intValue() == entity.getGlobalMark().intValue()) {
                entity.setType("全局");
            } else {
                entity.setType("组织");
            }
        }


        // 获取主要岗位
        List<PositionEntity> positionEntityList = positionService.getListByOrgIdAndUserId(userEntity.getOrganizeId(),
                userEntity.getId());
        if (positionEntityList.size() > 0) {
            List<String> fullNames =
                    positionEntityList.stream().map(PositionEntity::getFullName).collect(Collectors.toList());
            vo.setPosition(String.join(",", fullNames));
        }


        // 获取用户头像
        if (!StringUtils.isEmpty(userEntity.getHeadIcon())) {
            vo.setAvatar(userEntity.getHeadIcon());
        }
        return ActionResult.success(vo);
    }

    /**
     * 递归找他的上级
     */
    public void getOrganizeName(List<OrganizeEntity> OrganizeList, String OrganizeId, StringBuilder organizeName) {
        List<OrganizeEntity> OrganizeList2 =
                OrganizeList.stream().filter(t -> t.getId().equals(OrganizeId)).collect(Collectors.toList());
        if (OrganizeList2.size() > 0) {
            for (OrganizeEntity organizeEntity : OrganizeList2) {
                if ("-1".equals(organizeEntity.getParentId())) {
                    //父级为-1时候退出
                    organizeName.append(organizeEntity.getFullName());
                } else {
                    organizeName.append(organizeEntity.getFullName() + "/");
                }
            }
            for (OrganizeEntity orgSub : OrganizeList2) {
                getOrganizeName(OrganizeList, orgSub.getParentId(), organizeName);
            }
        }
    }


    /**
     * 我的权限
     *
     * @return
     */
    @ApiOperation("系统权限")
    @GetMapping("/Authorize")
    public ActionResult<UserAuthorizeVO> getList() {

        AuthorizeVO authorizeModel = authorizeService.getAuthorize(false);
        List<AuthorizeEntity> authorizeList = new ArrayList<>();
        //赋值图标
        Map<String, ModuleModel> moduleMap = this.moduleList(authorizeModel.getModuleList());
        List<ModuleModel> modelList = authorizeModel.getModuleList();
        UserAuthorizeVO vo = UserAuthorizeVO.builder()
                .button(this.moduleButton(modelList, authorizeModel.getButtonList(), authorizeList, moduleMap))
                .column(this.moduleColumn(modelList, authorizeModel.getColumnList(), authorizeList, moduleMap))
                .form(this.moduleForm(modelList, authorizeModel.getFormsList(), authorizeList, moduleMap))
                .resource(this.resourceData(modelList, authorizeModel.getResourceList(), authorizeList, moduleMap))
                .module(this.module(authorizeModel.getModuleList(), authorizeList)).build();
        return ActionResult.success(vo);
    }

    /**
     * 安全审计获取全部系统权限
     *
     * @return
     */
    @ApiOperation("安全审计获取全部系统权限")
    @GetMapping("/getAllAuthorize")
    public ActionResult<UserAuthorizeVO> getAllAuthorize() throws Exception {

        UserInfo userInfo = new UserInfo();
        userInfo.setIsAdministrator(true);
        AuthorizeVO authorizeModel = authorizeService.getAuthorize(userInfo);
        List<AuthorizeEntity> authorizeList = new ArrayList<>();
        //赋值图标
        Map<String, ModuleModel> moduleMap = this.moduleList(authorizeModel.getModuleList());
        List<ModuleModel> modelList = authorizeModel.getModuleList();
        UserAuthorizeVO vo = UserAuthorizeVO.builder()
                .button(this.moduleButton(modelList, authorizeModel.getButtonList(), authorizeList, moduleMap))
                .column(this.moduleColumn(modelList, authorizeModel.getColumnList(), authorizeList, moduleMap))
                .form(this.moduleForm(modelList, authorizeModel.getFormsList(), authorizeList, moduleMap))
                .resource(this.resourceData(modelList, authorizeModel.getResourceList(), authorizeList, moduleMap))
                .module(this.module(authorizeModel.getModuleList(), authorizeList)).build();
        return ActionResult.success(vo);
    }

    /**
     * 系统日志
     *
     * @param userLogForm
     * @return
     */
    @ApiOperation("系统日志")
    @GetMapping("/SystemLog")
    public ActionResult<PageListVO<UserLogVO>> getLogList(UserLogForm userLogForm) {
        List<LogEntity> data = logService.getList(userLogForm);
        List<UserLogVO> list = JsonUtil.getJsonToList(data, UserLogVO.class);
        for (int i = 0; i < list.size(); i++) {
            list.get(i).setIpaddress(data.get(i).getIpAddress());
            list.get(i).setRequestURL(data.get(i).getRequestUrl());
        }
        PaginationVO paginationVO = JsonUtil.getJsonToBean(userLogForm, PaginationVO.class);
        return ActionResult.page(list, paginationVO);
    }

    /**
     * 修改用户资料
     *
     * @param userInfoForm
     * @return
     */
    @ApiOperation("修改用户资料")
    @PutMapping("/BaseInfo")
    @HandleLog(moduleName = "用户管理", requestMethod = "修改用户资料")
    public ActionResult updateInfo(@RequestBody UserInfoForm userInfoForm) throws Exception {
        userService.updateBySetting(userInfoForm);
        return ActionResult.success(MsgCode.SU002.get());
    }

    /**
     * 修改用户密码
     *
     * @return
     */
    @ApiOperation("修改用户密码")
    @PostMapping("/Actions/ModifyPassword")
    @HandleLog(moduleName = "用户管理", requestMethod = "修改用户密码")
    public ActionResult modifyPassword(@RequestBody @Valid UserModifyPasswordForm userModifyPasswordForm) {
        UserEntity userEntity = userService.getInfo(userProvider.get().getUserId());
        if (userEntity != null) {
//            if ("1".equals(String.valueOf(userEntity.getIsAdministrator()))) {
//                return ActionResult.fail("无法修改管理员账户");
//            }
            String timestamp = String.valueOf(cacheUtil.query(userModifyPasswordForm.getTimestamp()));
            if (!userModifyPasswordForm.getCode().equalsIgnoreCase(timestamp)) {
                return ActionResult.fail(MsgCode.LOG104.get());
            }
            if (!Md5Util.getStringMd5((userModifyPasswordForm.getOldPassword().toLowerCase() + userEntity.getSecretkey().toLowerCase())).equals(userEntity.getPassword())) {
                return ActionResult.fail(MsgCode.LOG201.get());
            }
            userEntity.setPassword(userModifyPasswordForm.getPassword());
            userService.updatePassword(userEntity);
            userProvider.remove();
            return ActionResult.success(MsgCode.LOG202.get());
        }
        return ActionResult.fail(MsgCode.LOG203.get());

    }

    /**
     * 我的下属
     *
     * @param
     * @return
     */
    @ApiOperation("我的下属")
    @GetMapping("/Subordinate/{id}")
    public ActionResult getSubordinate(@PathVariable("id") String id) {
        List<UserIdListVo> userList = new ArrayList<>(16);
        List<UserSubordinateVO> list = new ArrayList<>();
        if ("0".equals(id)) {
            if (Objects.isNull(userProvider.get()) || StringUtils.isEmpty(userProvider.get().getUserId())) {
                return ActionResult.success(list);
            }
            userList.addAll(userService.getListByManagerId(userProvider.get().getUserId(), null));
        } else {
            userList = new ArrayList<>(userService.getListByManagerId(id, null));
        }
        for (UserIdListVo user : userList) {
            UserSubordinateVO subordinateVO = UserSubordinateVO.builder()
                    .id(user.getId())
                    .avatar(user.getHeadIcon())
                    .department(user.getOrganizeName())
                    .userName(user.getRealName())
                    .position(user.getPositionName())
                    .isLeaf(false).build();
            list.add(subordinateVO);
        }
        return ActionResult.success(list);
    }

    /**
     * 修改系统主题
     *
     * @param userThemeForm
     * @return
     */
    @ApiOperation("修改系统主题")
    @PutMapping("/SystemTheme")
    public ActionResult updateTheme(@RequestBody @Valid UserThemeForm userThemeForm) {
        UserEntity entity = JsonUtil.getJsonToBean(userThemeForm, UserEntity.class);
        entity.setId(userProvider.get().getUserId());
        userService.update(entity);
        return ActionResult.success(MsgCode.SU016.get());
    }

    /**
     * 修改头像
     *
     * @return
     */
    @ApiOperation("修改头像")
    @PutMapping("/Avatar/{name}")
    public ActionResult updateAvatar(@PathVariable("name") String name) throws Exception {
        UserInfo userInfo = userProvider.get();
        UserEntity userEntity = userService.getInfo(userInfo.getUserId());
        userEntity.setHeadIcon(name);
        userService.update(userEntity.getId(), userEntity);
        if (!StringUtils.isEmpty(userInfo.getId())) {
            userInfo.setUserIcon(name);
            cacheUtil.insert(LOGIN_CACHE, userInfo.getId(), userInfo,
                    DateUtil.getTime(userInfo.getOverdueTime()) - DateUtil.getTime(new Date()));
        }
        return ActionResult.success(MsgCode.SU004.get());
    }

    /**
     * 修改头像
     *
     * @return
     */
    @ApiOperation("修改头像")
    @PutMapping("/Avatar")
    public ActionResult updateAvatar(@RequestBody @Valid UserUpAvatarForm avatarForm) throws Exception {
        String name = avatarForm.getHeadIcon();
        UserInfo userInfo = userProvider.get();
        UserEntity userEntity = userService.getInfo(userInfo.getUserId());
        userEntity.setHeadIcon(name);
        userService.update(userEntity.getId(), userEntity);
        if (!StringUtils.isEmpty(userInfo.getId())) {
            userInfo.setUserIcon(name);
            cacheUtil.insert(LOGIN_CACHE, userInfo.getId(), userInfo,
                    DateUtil.getTime(userInfo.getOverdueTime()) - DateUtil.getTime(new Date()));
        }
        return ActionResult.success(MsgCode.SU004.get());
    }

    /**
     * 修改系统语言
     *
     * @param userLanguageForm
     * @return
     */
    @ApiOperation("修改系统语言")
    @PutMapping("/SystemLanguage")
    public ActionResult updateLanguage(@RequestBody @Valid UserLanguageForm userLanguageForm) {
        UserEntity userEntity = userService.getInfo(userProvider.get().getUserId());
        userEntity.setLanguage(userLanguageForm.getLanguage());
        userService.update(userEntity);
        return ActionResult.success(MsgCode.SU016.get());
    }


    /**
     * 赋值图标
     *
     * @param moduleList
     * @return
     */
    private Map<String, ModuleModel> moduleList(List<ModuleModel> moduleList) {
        Map<String, ModuleModel> auth = new HashMap<>(16);
        for (ModuleModel module : moduleList) {
            auth.put(module.getId(), module);
            module.setIcon(module.getIcon());
        }
        return auth;
    }

    /**
     * 功能权限
     *
     * @param moduleList    功能
     * @param authorizeLiat 权限集合
     * @return
     */
    private List<UserAuthorizeModel> module(List<ModuleModel> moduleList, List<AuthorizeEntity> authorizeLiat) {
        List<String> appId =
                moduleList.stream().filter(t -> "App".equals(t.getCategory())|| t.getType()==0).map(t -> t.getId()).collect(Collectors.toList());
        List<AuthorizeModel> treeList = JsonUtil.getJsonToList(moduleList, AuthorizeModel.class);
        List<SumTree<AuthorizeModel>> trees = TreeDotUtils.convertListToTreeDot(treeList, "-1");
        List<UserAuthorizeModel> vo = JsonUtil.getJsonToList(trees, UserAuthorizeModel.class);
        return vo;
    }

    /**
     * 按钮权限
     *
     * @param moduleList       功能
     * @param moduleButtonList 按钮
     * @param authorizeLiat    权限集合
     * @return
     */
    private List<UserAuthorizeModel> moduleButton(List<ModuleModel> moduleList, List<ButtonModel> moduleButtonList,
                                                  List<AuthorizeEntity> authorizeLiat,
                                                  Map<String, ModuleModel> moduleMap) {
        List<AuthorizeModel> treeList = new ArrayList<>();
        Set<String> moduleModeId = new HashSet<>();
        //获取按钮的菜单id
        for (ButtonModel buttonModel : moduleButtonList) {
            moduleModeId.add(buttonModel.getModuleId());
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(buttonModel.getId());
            treeModel.setFullName(buttonModel.getFullName());
            treeModel.setParentId(buttonModel.getModuleId());
            treeModel.setIcon(buttonModel.getIcon());
            ModuleEntity info = moduleService.getInfo(buttonModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull(info)?info.getCategory():"");
            treeList.add(treeModel);
        }
        List<ModuleModel> buttonList =
                moduleList.stream().filter(t -> moduleModeId.contains(t.getId())).collect(Collectors.toList());
        List<AuthorizeModel> moduleListAll = JsonUtil.getJsonToList(ListToTreeUtil.treeWhere(buttonList, moduleList),
                AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList =
                treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List<SumTree<AuthorizeModel>> trees = TreeDotUtils.convertListToTreeDot(treeList, "-1");
        //组装菜单树
        List<String> appId =
                moduleList.stream().filter(t -> "App".equals(t.getCategory())|| t.getType()==0).map(t -> t.getId()).collect(Collectors.toList());
        List<UserAuthorizeModel> data = JsonUtil.getJsonToList(trees, UserAuthorizeModel.class);
        return data;
    }

    /**
     * 列表权限
     *
     * @param moduleList       功能
     * @param moduleColumnList 列表
     * @param authorizeLiat    权限集合
     * @return
     */
    private List<UserAuthorizeModel> moduleColumn(List<ModuleModel> moduleList, List<ColumnModel> moduleColumnList,
                                                  List<AuthorizeEntity> authorizeLiat,
                                                  Map<String, ModuleModel> moduleMap) {
        List<AuthorizeModel> treeList = new ArrayList<>();
        List<String> moduleModeId = new ArrayList<>();
        //获取按钮的菜单id
        for (ColumnModel columnModel : moduleColumnList) {
            moduleModeId.add(columnModel.getModuleId());
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(columnModel.getId());
            treeModel.setFullName(columnModel.getFullName());
            treeModel.setParentId(columnModel.getModuleId());
            treeModel.setIcon("fa fa-tags column");
            ModuleEntity info = moduleService.getInfo(columnModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull(info)?info.getCategory():"");
            treeList.add(treeModel);
        }
        List<ModuleModel> buttonList =
                moduleList.stream().filter(t -> moduleModeId.contains(t.getId())).collect(Collectors.toList());
        List<AuthorizeModel> moduleListAll = JsonUtil.getJsonToList(ListToTreeUtil.treeWhere(buttonList, moduleList),
                AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList =
                treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List<SumTree<AuthorizeModel>> trees = TreeDotUtils.convertListToTreeDot(treeList, "-1");
        List<UserAuthorizeModel> data = JsonUtil.getJsonToList(trees, UserAuthorizeModel.class);
        return data;
    }

    /**
     * 表单权限
     *
     * @param moduleList     功能
     * @param moduleFormList 表单
     * @param authorizeLiat  权限集合
     * @return ignore
     */
    private List<UserAuthorizeModel> moduleForm(List<ModuleModel> moduleList, List<ModuleFormModel> moduleFormList,
                                                List<AuthorizeEntity> authorizeLiat,
                                                Map<String, ModuleModel> moduleMap) {
        List<AuthorizeModel> treeList = new ArrayList<>();
        List<String> moduleModeId = new ArrayList<>();
        //获取按钮的菜单id
        for (ModuleFormModel formModel : moduleFormList) {
            moduleModeId.add(formModel.getModuleId());
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(formModel.getId());
            treeModel.setFullName(formModel.getFullName());
            treeModel.setParentId(formModel.getModuleId());
            treeModel.setIcon("fa fa-binoculars resource");
            ModuleEntity info = moduleService.getInfo(formModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull(info)?info.getCategory():"");
            treeList.add(treeModel);
        }
        List<ModuleModel> buttonList =
                moduleList.stream().filter(t -> moduleModeId.contains(t.getId())).collect(Collectors.toList());
        List<AuthorizeModel> moduleListAll = JsonUtil.getJsonToList(ListToTreeUtil.treeWhere(buttonList, moduleList),
                AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList =
                treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List<SumTree<AuthorizeModel>> trees = TreeDotUtils.convertListToTreeDot(treeList, "-1");
        List<UserAuthorizeModel> data = JsonUtil.getJsonToList(trees, UserAuthorizeModel.class);
        return data;
    }

    /**
     * 数据权限
     *
     * @param moduleList         功能
     * @param moduleResourceList 资源
     * @param authorizeLiat      权限集合
     * @return ignore
     */
    private List<UserAuthorizeModel> resourceData(List<ModuleModel> moduleList,
                                                  List<ResourceModel> moduleResourceList,
                                                  List<AuthorizeEntity> authorizeLiat,
                                                  Map<String, ModuleModel> moduleMap) {
        List<AuthorizeModel> treeList = new ArrayList<>();
        List<String> moduleModeId = new ArrayList<>();
        //获取按钮的菜单id
        for (ResourceModel resourceModel : moduleResourceList) {
            moduleModeId.add(resourceModel.getModuleId());
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(resourceModel.getId());
            treeModel.setFullName(resourceModel.getFullName());
            treeModel.setParentId(resourceModel.getModuleId());
            treeModel.setIcon("fa fa-binoculars resource");
            ModuleEntity info = moduleService.getInfo(resourceModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull(info)?info.getCategory():"");
            treeList.add(treeModel);
        }
        List<ModuleModel> buttonList =
                moduleList.stream().filter(t -> moduleModeId.contains(t.getId())).collect(Collectors.toList());
        List<AuthorizeModel> moduleListAll = JsonUtil.getJsonToList(ListToTreeUtil.treeWhere(buttonList, moduleList),
                AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList =
                treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List<SumTree<AuthorizeModel>> trees = TreeDotUtils.convertListToTreeDot(treeList, "-1");
        List<UserAuthorizeModel> data = JsonUtil.getJsonToList(trees, UserAuthorizeModel.class);
        return data;
    }

    @ApiOperation("设置主要组织、主要岗位（角色当前不做）")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "majorType", value = "组织:Organize/岗位:Position", dataType = "String"),
            @ApiImplicitParam(name = "majorId", value = "组织/岗位id", dataType = "String")})
    @PutMapping("/major")
    public ActionResult<String> defaultOrganize(@RequestBody UserSettingForm userSettingForm) {
        UserEntity userEntity = userService.getInfo(userProvider.get().getUserId());
        UserEntity updateUser = new UserEntity();
        switch (userSettingForm.getMajorType()) {
            case PermissionConst.ORGANIZE:
                String orgId = userSettingForm.getMajorId();
                // 对角色权限进行验证
                if (!organizeRelationService.checkBasePermission(userEntity.getId(), orgId)) {
                    return ActionResult.fail(MsgCode.FA025.get());
                }
                updateUser.setOrganizeId(orgId);
                // 岗位自动切换
                updateUser.setPositionId(organizeRelationService.autoGetMajorPositionId(userEntity.getId(), orgId,
                        userEntity.getPortalId()));
                break;
            case PermissionConst.POSITION:
                updateUser.setPositionId(userSettingForm.getMajorId());
                break;
            default:
                break;
        }
        updateUser.setId(userEntity.getId());
        userService.update(updateUser);
        String key = cacheKeyUtil.getUserAuthorize() + userProvider.get().getUserId();
        cacheUtil.remove(LOGIN_CACHE, key);
        return ActionResult.success(MsgCode.SU016.get());
    }

    @ApiOperation("获取当前用户所有组织")
    @GetMapping("/getUserOrganizes")
    public ActionResult<List<PermissionModel>> getUserOrganizes() {
        return ActionResult.success(userRelationService.getObjectVoList(PermissionConst.ORGANIZE));
    }

    @ApiOperation("根据用户id获取用户所有组织")
    @GetMapping("/getUserOrganizesById/{id}")
    public ActionResult<List<PermissionModel>> getUserOrganizesById(@PathVariable("id") String id) {
        return ActionResult.success(userRelationService.getObjectVoListById(id, PermissionConst.ORGANIZE));
    }

    @ApiOperation("获取当前用户当前组织底下所有岗位")
    @GetMapping("/getUserPositions")
    public ActionResult<List<PermissionModel>> getUserPositions() {
        return ActionResult.success(userRelationService.getObjectVoList(PermissionConst.POSITION));
    }

    @ApiOperation("根据用户id获取用户当前组织底下所有岗位")
    @GetMapping("/getUserPositionsById/{id}")
    public ActionResult<List<PermissionModel>> getUserPositionsById(@PathVariable("id") String id) {
        return ActionResult.success(userRelationService.getObjectVoListById(id, PermissionConst.POSITION));
    }

    @ApiOperation("获取当前用户所有角色")
    @GetMapping("/getUserRoles")
    public ActionResult<List<PermissionModel>> getUserRoles() {
        return ActionResult.success(userRelationService.getObjectVoList(PermissionConst.ROLE));
    }

    @ApiOperation("根据用户id获取菜单列表信息")
    @PostMapping("/getMenuListByUserId/{userId}")
    public ActionResult<AuthorizeDataReturnVO> getMenuListByUserId(@PathVariable("userId") String userId, @RequestBody DataValuesQuery dataValuesQuery) throws Exception {

        //查询出该用户下全部角色信息
        QueryWrapper<UserRelationEntity> roleQuery = new QueryWrapper<>();
        roleQuery.lambda().eq(UserRelationEntity::getUserId, userId);
        roleQuery.lambda().eq(UserRelationEntity::getObjectType, PermissionConst.ROLE);
        List<String> roleIdList = new ArrayList<>();
        for (UserRelationEntity ure : userRelationService.list(roleQuery)) {
            roleIdList.add(ure.getObjectId());
        }
        String ids = roleIdList.stream().collect(Collectors.joining(","));
        ActionResult<AuthorizeDataReturnVO> menuListByRoleIds = this.getMenuListByRoleIds(ids,dataValuesQuery);
        return menuListByRoleIds;

    }
    @ApiOperation("根据角色id集合获取菜单列表信息")
    @PostMapping("/getMenuListByRoleIds/{roleIds}")
    public ActionResult<AuthorizeDataReturnVO> getMenuListByRoleIds(@PathVariable("roleIds") String roleIds, @RequestBody DataValuesQuery dataValuesQuery) throws Exception {
        String[] split = roleIds.split(",");
        List<String> roleIdList = new ArrayList<>();
        for (String id : split) {
            roleIdList.add(id);
        }
        List<RoleEntity> listByIds = roleService.getListByIds(roleIdList);
        //循环角色列表查询出角色下全部菜单信息
        //数据类型  module-菜单 button-按钮  column-列表 resource-数据 form-表单
        //存储查询出来的数据列表
        List<AuthorizeDataReturnModel> dataReturnModelList = new ArrayList<>();
        List<String> ids = new ArrayList<>();

        DataValuesQuery module = new DataValuesQuery();
        module.setType("module");
        for(RoleEntity roleEntity:listByIds){
            String objectId = roleEntity.getId();
            AuthorizeVO authorizeModel = authorizeService.getAuthorizeByRoleId(objectId);
            List<AuthorizeEntity> list = authorizeService.list(new QueryWrapper<AuthorizeEntity>().lambda().eq(AuthorizeEntity::getObjectId, objectId));
            if (!StringUtils.isEmpty(dataValuesQuery.getType())) {

                AuthorizeDataReturnVO authorizeDataReturnVO = authorizeService.getAuthorizeDataReturnVO(authorizeModel,list,module,objectId);
                dataReturnModelList.addAll(authorizeDataReturnVO.getList());
                ids.addAll(authorizeDataReturnVO.getIds());
            }else{
                return ActionResult.fail("类型不能为空");
            }
        }
        List<String> listWithoutDuplicates = ids.stream()
                .distinct()
                .collect(Collectors.toList());
        //如果不是查询菜单的话 需要根据上面查询出来的菜单过滤出来其他类型的列表
        if(!StringUtils.isEmpty(dataValuesQuery.getType()) && !"module".equals(dataValuesQuery.getType()) && listWithoutDuplicates.size()>0){
            dataValuesQuery.setModuleIds(String.join(",",listWithoutDuplicates));
            dataReturnModelList = new ArrayList<>();
            for(RoleEntity roleEntity:listByIds){
                String objectId = roleEntity.getId();
                AuthorizeVO authorizeModel = authorizeService.getAuthorizeByRoleId(objectId);
                List<AuthorizeEntity> list = authorizeService.list(new QueryWrapper<AuthorizeEntity>().lambda().eq(AuthorizeEntity::getObjectId, objectId));
                if (!StringUtils.isEmpty(dataValuesQuery.getType())) {
                    AuthorizeDataReturnVO authorizeDataReturnVO = authorizeService.getAuthorizeDataReturnVO(authorizeModel,list,dataValuesQuery,objectId);
                    dataReturnModelList.addAll(authorizeDataReturnVO.getList());
                    ids.addAll(authorizeDataReturnVO.getIds());
                }else{
                    return ActionResult.fail("类型不能为空");
                }
            }
        }
        //进行去重处理
        List<AuthorizeDataReturnModel> authorizeDataReturnModels = RecursiveRemovalUtil.deduplicateAndMerge(dataReturnModelList);
        List<AuthorizeDataReturnModel> authorizeDataReturnModelList = new ArrayList<>();
        for (int i =0;i<authorizeDataReturnModels.size();i++) {
            AuthorizeDataReturnModel authorizeDataReturnModel =authorizeDataReturnModels.get(i);
            if(StringUtils.isNotEmpty(authorizeDataReturnModel.getType()) && "root".equals(authorizeDataReturnModel.getType())){
                authorizeDataReturnModelList.add(authorizeDataReturnModel);
            }
        }
        String str = JsonUtil.getListToJsonArray(authorizeDataReturnModelList).toJSONString();
        if(str.contains("$ref")){
            authorizeDataReturnModelList = RecursiveRemovalUtil.deduplicateAndKeepDeepest(authorizeDataReturnModelList);
        }


        AuthorizeDataReturnVO returnVO = new AuthorizeDataReturnVO();
        returnVO.setList(authorizeDataReturnModelList);
        returnVO.setIds(listWithoutDuplicates);
        System.out.println(JsonUtil.getListToJsonArray(authorizeDataReturnModelList).toJSONString());
        return ActionResult.success(returnVO);

    }

    @ApiOperation("根据菜单id获取拥有该菜单的全部人员信息")
    @PostMapping("/getUserListByMenuId/{menuId}")
    public ActionResult<PageListVO<UserListVO>> getUserListByMenuId(@PathVariable("menuId") String menuId,
                                                                    @RequestBody PaginationUser paginationUser) {
        List<AuthorizeEntity> authorizeEntityList = roleService.getListBymenuId(menuId);
        List<UserEntity> userList = userService.getUserListByMenuId(authorizeEntityList, paginationUser);

        List<UserListVO> list = JsonUtil.getJsonToList(userList, UserListVO.class);
        for (UserListVO vo : list) {
            // 获取组织
            String organizeStr = userRelationService.getAllOrganizeNameInfoById(vo.getId());

            vo.setOrganize(organizeStr);
        }
        PaginationVO paginationVO = JsonUtil.getJsonToBean(paginationUser, PaginationVO.class);
        return ActionResult.page(list, paginationVO);
    }
    
    @ApiOperation("根据角色id获取全部人员信息")
    @PostMapping("/getUserListByRoleId/{roleId}")
    public ActionResult<PageListVO<UserListVO>> getUserListByRoleId(@PathVariable("roleId") String roleId,@RequestBody PaginationUser paginationUser){
        List<AuthorizeEntity> authorizeEntityList = new ArrayList<>();
        AuthorizeEntity authorizeEntity = new AuthorizeEntity();
        authorizeEntity.setObjectId(roleId);
        authorizeEntityList.add(authorizeEntity);
        List<UserEntity> userList = userService.getUserListByMenuId(authorizeEntityList,paginationUser);

        List<UserListVO> list = JsonUtil.getJsonToList(userList,UserListVO.class);
        for (UserListVO vo: list) {
            // 获取组织
            String organizeStr = userRelationService.getAllOrganizeNameInfoById(vo.getId());

            vo.setOrganize(organizeStr);
        }
        PaginationVO paginationVO = JsonUtil.getJsonToBean(paginationUser, PaginationVO.class);
        return ActionResult.page(list, paginationVO);
    }

    /**
     * 修改app常用
     *
     * @param userAppDataForm
     * @return
     */
    @ApiOperation("修改app常用数据")
    @PutMapping("/SystemAppData")
    public ActionResult updateAppData(@RequestBody @Valid UserAppDataForm userAppDataForm) {
        UserInfo userInfo = userProvider.get();
        UserEntity entity = userService.getInfo(userInfo.getUserId());
        entity.setPropertyJson(userAppDataForm.getData());
        userService.update(entity);
        return ActionResult.success(MsgCode.SU016.get());
    }

}
