package com.bringspring.system.permission.service.strategy;

import com.alibaba.fastjson.JSON;
import com.bringspring.common.util.enums.AuthorizeConditionEnum;
import com.bringspring.common.util.enums.SearchMethodEnum;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;

import static com.bringspring.common.util.enums.SearchMethodEnum.Between;

/**
 * This class is used to handle the input number condition.
 */
@Component
public class ContentInputNumber extends FieldContentNumberStrategy {

    public ContentInputNumber() {
        super();
        this.order = 10;
        this.conditionOptions = new ArrayList<>();
        conditionOptions.add(new HashMap<String, Object>() {{
            put("value", AuthorizeConditionEnum.INPUTNUMBER.getCondition());
            put("label", AuthorizeConditionEnum.INPUTNUMBER.getMessage());
        }});
        this.symbolOptions = SearchMethodEnum.getSymbolOptionsDateNum();
    }

    @Override
    public Object convertFieldContent(String fieldContent, String symbol) {
        if (symbol.equals(Between.getSymbol())) {
            // 字段内容应为数字范围，格式为[数字1,数字2]，用JSON.parseArray()方法解析
            return JSON.parseArray(fieldContent);
        }
        return fieldContent;
    }
}
