package com.bringspring.system.print.model.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 打印模板-数据传输对象
 *
 * @author RKKJ开发平台组 YY
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月30日
 */
@Data
public class PrintDevFormDTO {

    @ApiModelProperty(value = "主键_id")
    private String id;

    @NotBlank(message = "必填")
    @ApiModelProperty(value = "名称")
    private String fullName;

    @NotBlank(message = "必填")
    @ApiModelProperty(value = "编码",required = true)
    private String enCode;

    @NotBlank(message = "必填")
    @ApiModelProperty(value = "分类")
    private String category;

    @NotNull(message = "必填")
    @ApiModelProperty(value = "类型")
    private Integer type;

    @ApiModelProperty(value = "描述")
    private String description;

    @NotNull(message = "必填")
    @ApiModelProperty(value = "排序码")
    private Long sortCode;

    @NotNull(message = "必填")
    @ApiModelProperty(value = "有效标志")
    private Integer enabledMark;

    @ApiModelProperty(value = "创建时间")
    private Long creatorTime;

    @ApiModelProperty(value = "创建用户_id")
    private String creatorUserId;

    @ApiModelProperty(value = "修改时间")
    private Long lastModifyTime;

    @ApiModelProperty(value = "修改用户_id")
    private String lastModifyUserId;

    @ApiModelProperty(value = "删除标志")
    private Integer deleteMark;

    @ApiModelProperty(value = "删除时间")
    private LocalDateTime deleteTime;

    @ApiModelProperty(value = "删除用户_id")
    private String deleteUserId;

    @NotBlank(message = "必填")
    @ApiModelProperty(value = "连接数据_id")
    private String dbLinkId;

    @ApiModelProperty(value = "sql语句")
    private String sqlTemplate;

    @ApiModelProperty(value = "左侧字段")
    private String leftFields;

    @ApiModelProperty(value = "打印模板")
    private String printTemplate;


}
