/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.enums.DictionaryDataEnum;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.file.FileExport;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.common.util.wxutil.HttpUtil;
import com.bringspring.system.base.entity.DataInterfaceEntity;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.model.dataInterface.DataInterfaceCrForm;
import com.bringspring.system.base.model.dataInterface.DataInterfaceExport;
import com.bringspring.system.base.model.dataInterface.DataInterfaceGetListVO;
import com.bringspring.system.base.model.dataInterface.DataInterfaceListVO;
import com.bringspring.system.base.model.dataInterface.DataInterfaceModel;
import com.bringspring.system.base.model.dataInterface.DataInterfacePage;
import com.bringspring.system.base.model.dataInterface.DataInterfaceParamModel;
import com.bringspring.system.base.model.dataInterface.DataInterfaceTreeModel;
import com.bringspring.system.base.model.dataInterface.DataInterfaceTreeVO;
import com.bringspring.system.base.model.dataInterface.DataInterfaceUpForm;
import com.bringspring.system.base.model.dataInterface.DataInterfaceVo;
import com.bringspring.system.base.model.dataInterface.PaginationDataInterface;
import com.bringspring.system.base.model.dataInterface.PaginationDataInterfaceModel;
import com.bringspring.system.base.service.DataInterfaceService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.base.util.Props;
import com.bringspring.system.permission.service.UserService;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6570\u636e\u63a5\u53e3"}, value="DataInterface")
@RestController
@RequestMapping(value={"/api/system/DataInterface"})
public class DataInterfaceController {
    @Autowired
    private DataInterfaceService dataInterfaceService;
    @Autowired
    private UserService userService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private Props props;

    @ApiOperation(value="\u83b7\u53d6\u63a5\u53e3\u5217\u8868(\u5206\u9875)")
    @GetMapping
    public ActionResult<PageListVO<DataInterfaceListVO>> getList(PaginationDataInterface pagination) {
        List<DataInterfaceEntity> data = this.dataInterfaceService.getList(pagination, null);
        List list = JsonUtil.getJsonToList(data, DataInterfaceListVO.class);
        for (DataInterfaceListVO vo : list) {
            if (StringUtils.isNotEmpty((String)this.userProvider.get().getTenantId())) {
                vo.setTenantId(this.userProvider.get().getTenantId());
            }
            if ("1".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("\u589e\u52a0");
                continue;
            }
            if ("2".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("\u4fee\u6539");
                continue;
            }
            if ("3".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("\u67e5\u8be2");
                continue;
            }
            if ("4".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("\u5220\u9664");
                continue;
            }
            if ("5".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("\u5b58\u50a8");
                continue;
            }
            if ("6".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("GET");
                continue;
            }
            if (!"7".equals(vo.getRequestMethod())) continue;
            vo.setRequestMethod("POST");
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u63a5\u53e3\u5217\u8868(\u5de5\u4f5c\u6d41\u9009\u62e9\u65f6\u8c03\u7528)")
    @GetMapping(value={"/getList"})
    public ActionResult<PageListVO<DataInterfaceGetListVO>> getLists(PaginationDataInterfaceModel pagination) {
        List<DataInterfaceEntity> data = this.dataInterfaceService.getList(pagination, pagination.getDataType());
        List list = JsonUtil.getJsonToList(data, DataInterfaceGetListVO.class);
        for (DataInterfaceGetListVO vo : list) {
            if ("1".equals(vo.getDataType())) {
                vo.setDataType("SQL\u64cd\u4f5c");
            } else if ("2".equals(vo.getDataType())) {
                vo.setDataType("\u9759\u6001\u6570\u636e");
            } else if ("3".equals(vo.getDataType())) {
                vo.setDataType("Api\u6570\u636e");
            }
            if ("1".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("\u589e\u52a0");
                continue;
            }
            if ("2".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("\u4fee\u6539");
                continue;
            }
            if ("3".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("\u67e5\u8be2");
                continue;
            }
            if ("4".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("\u5220\u9664");
                continue;
            }
            if ("5".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("\u5b58\u50a8");
                continue;
            }
            if ("6".equals(vo.getRequestMethod())) {
                vo.setRequestMethod("GET");
                continue;
            }
            if (!"7".equals(vo.getRequestMethod())) continue;
            vo.setRequestMethod("POST");
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u63a5\u53e3\u5217\u8868\u4e0b\u62c9\u6846")
    @GetMapping(value={"/GetParam/{id}"})
    public ActionResult getSelector(@PathVariable(value="id") String id) {
        DataInterfaceEntity info = this.dataInterfaceService.getInfo(id);
        if (info != null) {
            String requestParameters = info.getRequestParameters();
            List jsonToList = JsonUtil.getJsonToList((String)requestParameters, DataInterfaceModel.class);
            return ActionResult.success((Object)(jsonToList == null ? new ArrayList() : jsonToList));
        }
        return ActionResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u83b7\u53d6\u63a5\u53e3\u5217\u8868\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<List<DataInterfaceTreeVO>> getSelector() {
        ArrayList<DataInterfaceTreeModel> tree = new ArrayList<DataInterfaceTreeModel>();
        List<DataInterfaceEntity> data = this.dataInterfaceService.getList();
        List<DictionaryDataEntity> dataEntityList = this.dictionaryDataService.getList(DictionaryDataEnum.SYSTEM_DATAINTERFACE.getDictionaryTypeId());
        for (DictionaryDataEntity dictionaryDataEntity : dataEntityList) {
            DataInterfaceTreeModel firstModel = (DataInterfaceTreeModel)((Object)JsonUtil.getJsonToBean((Object)dictionaryDataEntity, DataInterfaceTreeModel.class));
            firstModel.setId(dictionaryDataEntity.getId());
            firstModel.setCategoryId("0");
            long num = data.stream().filter(t -> t.getCategoryId().equals(dictionaryDataEntity.getId())).count();
            if (num <= 0L) continue;
            tree.add(firstModel);
        }
        for (DataInterfaceEntity entity : data) {
            DataInterfaceTreeModel treeModel = (DataInterfaceTreeModel)((Object)JsonUtil.getJsonToBean((Object)entity, DataInterfaceTreeModel.class));
            treeModel.setCategoryId("1");
            treeModel.setParentId(entity.getCategoryId());
            treeModel.setId(entity.getId());
            DictionaryDataEntity dataEntity = this.dictionaryDataService.getInfo(entity.getCategoryId());
            if (dataEntity == null) continue;
            tree.add(treeModel);
        }
        List sumTrees = TreeDotUtils.convertListToTreeDot(tree);
        List list = JsonUtil.getJsonToList((Object)sumTrees, DataInterfaceTreeVO.class);
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)list);
    }

    @ApiOperation(value="\u83b7\u53d6\u63a5\u53e3\u6570\u636e")
    @GetMapping(value={"/{id}"})
    public ActionResult<DataInterfaceVo> getInfo(@PathVariable(value="id") String id) throws DataException {
        DataInterfaceEntity entity = this.dataInterfaceService.getInfo(id);
        DataInterfaceVo vo = JsonUtilEx.getJsonToBeanEx(entity, DataInterfaceVo.class);
        if (vo.getCheckType() == null) {
            vo.setCheckType(0);
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6dfb\u52a0\u63a5\u53e3")
    @PostMapping
    public ActionResult create(@RequestBody @Valid DataInterfaceCrForm dataInterfaceCrForm) {
        DataInterfaceEntity entity = (DataInterfaceEntity)JsonUtil.getJsonToBean((Object)dataInterfaceCrForm, DataInterfaceEntity.class);
        String containsSensitive = this.containsSensitive(dataInterfaceCrForm.getQuery());
        if (StringUtils.isNotEmpty((String)containsSensitive)) {
            return ActionResult.fail((String)containsSensitive);
        }
        if (this.dataInterfaceService.isExistByFullName(entity.getFullName(), entity.getId())) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        if (this.dataInterfaceService.isExistByEnCode(entity.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        this.dataInterfaceService.create(entity);
        return ActionResult.success((String)"\u63a5\u53e3\u521b\u5efa\u6210\u529f");
    }

    private String containsSensitive(String sql) {
        if (StringUtils.isNotEmpty((String)sql)) {
            String[] split = "CREATE,UNIQUE,CHECK,DEFAULT,DROP,INDEX,ALTER,TABLE,VIEW".split(",");
            SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (String)"mysql", (SQLParserFeature[])new SQLParserFeature[0]);
            String token = parser.getExprParser().getLexer().token().toString();
            for (String str : split) {
                boolean contains = token.contains(str.trim());
                if (!contains) continue;
                return str.trim();
            }
        }
        return "";
    }

    @ApiOperation(value="\u4fee\u6539\u63a5\u53e3")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@RequestBody @Valid DataInterfaceUpForm dataInterfaceUpForm, @PathVariable(value="id") String id) throws DataException {
        DataInterfaceEntity entity = JsonUtilEx.getJsonToBeanEx(dataInterfaceUpForm, DataInterfaceEntity.class);
        String containsSensitive = this.containsSensitive(dataInterfaceUpForm.getQuery());
        if (StringUtils.isNotEmpty((String)containsSensitive)) {
            return ActionResult.fail((String)containsSensitive);
        }
        if (this.dataInterfaceService.isExistByFullName(entity.getFullName(), id)) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        if (this.dataInterfaceService.isExistByEnCode(entity.getEnCode(), id)) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        boolean flag = this.dataInterfaceService.update(entity, id);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA013.get());
        }
        return ActionResult.success((String)MsgCode.SU013.get());
    }

    @ApiOperation(value="\u5220\u9664\u63a5\u53e3")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable String id) {
        DataInterfaceEntity entity = this.dataInterfaceService.getInfo(id);
        if (entity != null) {
            this.dataInterfaceService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u66f4\u65b0\u63a5\u53e3\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult update(@PathVariable(value="id") String id) throws DataException {
        DataInterfaceEntity entity = this.dataInterfaceService.getInfo(id);
        if (entity != null) {
            if ("0".equals(String.valueOf(entity.getEnabledMark()))) {
                entity.setEnabledMark(1);
            } else {
                entity.setEnabledMark(0);
            }
            this.dataInterfaceService.update(entity, id);
            return ActionResult.success((String)MsgCode.SU014.get());
        }
        return ActionResult.fail((String)MsgCode.FA014.get());
    }

    @ApiOperation(value="\u83b7\u53d6\u63a5\u53e3\u5206\u9875\u6570\u636e")
    @GetMapping(value={"/{id}/Action/List"})
    public ActionResult list(@PathVariable(value="id") String id, DataInterfacePage page) {
        ActionResult result = this.dataInterfaceService.infoToIdPageList(id, page);
        return result;
    }

    @ApiOperation(value="\u83b7\u53d6\u63a5\u53e3\u8be6\u60c5\u6570\u636e")
    @GetMapping(value={"/{id}/Action/Info"})
    public ActionResult info(@PathVariable(value="id") String id, DataInterfacePage page) {
        Map<String, Object> data = this.dataInterfaceService.infoToInfo(id, page);
        return ActionResult.success(data);
    }

    @ApiOperation(value="\u9884\u89c8")
    @GetMapping(value={"/{id}/Preview"})
    public ActionResult Actions(@PathVariable(value="id") String id) {
        JSONObject jsonObject;
        String escape = XSSEscape.escape((String)id);
        Object preview = this.dataInterfaceService.preview(escape);
        if (preview instanceof JSONObject && Objects.nonNull(jsonObject = (JSONObject)preview) && "1".equals(jsonObject.get((Object)"errorCode"))) {
            return ActionResult.fail((String)String.valueOf(jsonObject.get((Object)"errorMsg")));
        }
        return ActionResult.success((Object)preview);
    }

    @ApiOperation(value="\u8bbf\u95ee\u63a5\u53e3")
    @GetMapping(value={"/{code}/Actions/Response"})
    @NoDataSourceBind
    public ActionResult getByCode(@PathVariable(value="code") String code, String tenantId, HttpServletRequest request) {
        ActionResult actionResult;
        String name = null;
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            if (StringUtil.isNotEmpty((String)tenantId)) {
                JSONObject object = HttpUtil.httpRequest((String)(this.props.getPortUrl() + tenantId), (String)"GET", null);
                if (object == null || StringUtil.isEmpty((String)object.getString("data"))) {
                    return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                }
                Map resulList = JsonUtil.stringToMap((String)object.getString("data"));
                name = resulList.get("java") != null ? String.valueOf(resulList.get("java")) : String.valueOf(resulList.get("dbName"));
                DataSourceContextHolder.setDatasource((String)tenantId, (String)name);
            } else {
                if (Objects.isNull(this.userProvider.get())) {
                    return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                }
                DataSourceContextHolder.setDatasource((String)this.userProvider.get().getTenantId(), (String)this.userProvider.get().getTenantDbConnectionString());
            }
        }
        Map parameterMap = request.getParameterMap();
        HashMap<String, String> map = new HashMap<String, String>();
        if (!parameterMap.isEmpty()) {
            for (Map.Entry entry : parameterMap.entrySet()) {
                String paramName = (String)entry.getKey();
                String[] paramValues = (String[])entry.getValue();
                map.put(paramName, paramValues[0]);
                System.out.println(paramName + paramValues[0]);
            }
        }
        if ((actionResult = this.dataInterfaceService.getApiById(code, name, map)).getCode() == 200) {
            actionResult.setMsg("\u63a5\u53e3\u8bf7\u6c42\u6210\u529f");
        }
        return actionResult;
    }

    @ApiOperation(value="\u6d4b\u8bd5\u63a5\u53e3")
    @PostMapping(value={"/{id}/Actions/Preview"})
    @NoDataSourceBind
    public ActionResult callPreview(@PathVariable(value="id") String id, @RequestBody DataInterfaceParamModel model) {
        String name = null;
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            if (StringUtils.isNotEmpty((String)model.getTenantId())) {
                JSONObject object = HttpUtil.httpRequest((String)(this.props.getPortUrl() + model.getTenantId()), (String)"GET", null);
                if (object == null || StringUtils.isEmpty((String)object.getString("data"))) {
                    return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                }
                Map resulList = JsonUtil.stringToMap((String)object.getString("data"));
                name = resulList.get("java") != null ? String.valueOf(resulList.get("java")) : String.valueOf(resulList.get("dbName"));
                DataSourceContextHolder.setDatasource((String)model.getTenantId(), (String)name);
            } else {
                if (Objects.isNull(this.userProvider.get())) {
                    return ActionResult.fail((String)ActionResultCode.SessionOverdue.getMessage());
                }
                DataSourceContextHolder.setDatasource((String)this.userProvider.get().getTenantId(), (String)this.userProvider.get().getTenantDbConnectionString());
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(model.getParamList().size());
        List jsonToList = JsonUtil.getJsonToList(model.getParamList(), DataInterfaceModel.class);
        for (DataInterfaceModel dataInterfaceModel : jsonToList) {
            map.put(dataInterfaceModel.getField(), dataInterfaceModel.getDefaultValue());
        }
        ActionResult actionResult = this.dataInterfaceService.infoToId(id, name, map);
        if (actionResult.getCode() == 200) {
            actionResult.setMsg("\u63a5\u53e3\u8bf7\u6c42\u6210\u529f");
        }
        return actionResult;
    }

    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u63a5\u53e3\u6570\u636e")
    @GetMapping(value={"/{id}/Action/Export"})
    public ActionResult exportFile(@PathVariable(value="id") String id) {
        DataInterfaceEntity entity = this.dataInterfaceService.getInfo(id);
        DataInterfaceExport dataInterfaceExport = (DataInterfaceExport)JsonUtil.getJsonToBean((Object)entity, DataInterfaceExport.class);
        DownloadVO downloadVO = this.fileExport.exportFile((Object)dataInterfaceExport, this.configValueUtil.getTemporaryFilePath(), entity.getFullName(), ModuleTypeEnum.SYSTEM_DATAINTEFASE.getTableName());
        return ActionResult.success((Object)downloadVO);
    }

    @ApiOperation(value="\u6570\u636e\u63a5\u53e3\u5bfc\u5165\u529f\u80fd")
    @PostMapping(value={"/Action/Import"}, consumes={"multipart/form-data"})
    public ActionResult importFile(@RequestPart(value="file") MultipartFile multipartFile) throws DataException {
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.SYSTEM_DATAINTEFASE.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get());
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile, (String)this.configValueUtil.getTemporaryFilePath());
        try {
            DataInterfaceEntity entity = (DataInterfaceEntity)JsonUtil.getJsonToBean((String)fileContent, DataInterfaceEntity.class);
            if (this.dictionaryDataService.getInfo(entity.getCategoryId()) == null) {
                return ActionResult.fail((String)MsgCode.IMP004.get());
            }
            if (this.dataInterfaceService.getInfo(entity.getId()) == null && !this.dataInterfaceService.isExistByFullName(entity.getFullName(), entity.getId()) && !this.dataInterfaceService.isExistByEnCode(entity.getEnCode(), entity.getId())) {
                this.dataInterfaceService.create(entity);
                return ActionResult.success((String)MsgCode.IMP001.get());
            }
        }
        catch (Exception e) {
            throw new DataException(MsgCode.IMP004.get());
        }
        return ActionResult.fail((String)MsgCode.IMP003.get());
    }
}

