/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.print.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.DbFieldMod;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DblinkService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.print.entity.OperatorRecordEntity;
import com.bringspring.system.print.entity.PrintDevEntity;
import com.bringspring.system.print.mapper.PrintDevMapper;
import com.bringspring.system.print.model.PaginationPrint;
import com.bringspring.system.print.model.PrintDevTreeModel;
import com.bringspring.system.print.model.vo.PrintDevVO;
import com.bringspring.system.print.service.IPrintDevService;
import com.bringspring.system.print.util.PrintDevUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrintDevServiceImpl
extends ServiceImpl<PrintDevMapper, PrintDevEntity>
implements IPrintDevService {
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private UserService userService;
    @Autowired
    private DataSourceModel dataSourceModel;
    @Autowired
    private DblinkService dblinkService;

    @Override
    public List<PrintDevEntity> getList(PaginationPrint paginationPrint) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)paginationPrint.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(PrintDevEntity::getFullName, (Object)paginationPrint.getKeyword())).or()).like(PrintDevEntity::getEnCode, (Object)paginationPrint.getKeyword());
            });
        }
        if (StringUtils.isNotEmpty((String)paginationPrint.getCategory())) {
            queryWrapper.lambda().eq(PrintDevEntity::getCategory, (Object)paginationPrint.getCategory());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PrintDevEntity::getSortCode)).orderByDesc(PrintDevEntity::getCreatorTime);
        Page page = new Page(paginationPrint.getCurrentPage(), paginationPrint.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationPrint.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public List<PrintDevVO> getTreeModel() throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PrintDevEntity::getSortCode)).orderByDesc(PrintDevEntity::getCreatorTime);
        return this.setTreeModel(this.list((Wrapper)queryWrapper));
    }

    @Override
    public List<PrintDevVO> getTreeModel(Integer type) throws Exception {
        QueryWrapper query = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)query.lambda().eq(PrintDevEntity::getType, (Object)type)).orderByAsc(PrintDevEntity::getSortCode)).orderByDesc(PrintDevEntity::getCreatorTime);
        List printEntityList = this.list((Wrapper)query);
        return this.setTreeModel(printEntityList);
    }

    private List<PrintDevVO> setTreeModel(List<PrintDevEntity> printEntityList) throws Exception {
        String encode = "printDev";
        DictionaryTypeEntity DictionaryType = this.dictionaryTypeService.getInfoByEnCode(encode);
        if (DictionaryType == null) {
            throw new Exception(MsgCode.PRI002.get());
        }
        List<DictionaryDataEntity> dicDataList = this.dictionaryDataService.getList(DictionaryType.getId());
        LinkedList<Object> modelAll = new LinkedList<Object>();
        for (DictionaryDataEntity dicEntity : dicDataList) {
            PrintDevTreeModel model = new PrintDevTreeModel();
            model.setFullName(dicEntity.getFullName());
            model.setId(dicEntity.getId());
            Long num = printEntityList.stream().filter(t -> t.getCategory().equals(dicEntity.getEnCode())).count();
            if (num <= 0L) continue;
            model.setNum(Integer.parseInt(num.toString()));
            modelAll.add((Object)model);
        }
        ArrayList<String> userId = new ArrayList<String>();
        printEntityList.forEach(t -> {
            userId.add(t.getCreatorUserId());
            if (StringUtils.isNotEmpty((String)t.getLastModifyUserId())) {
                userId.add(t.getLastModifyUserId());
            }
        });
        List<UserEntity> userList = this.userService.getUserName(userId);
        for (PrintDevEntity printEntity : printEntityList) {
            DictionaryDataEntity dicDataEntity = dicDataList.stream().filter(t -> t.getEnCode().equals(printEntity.getCategory())).findFirst().orElse(null);
            PrintDevTreeModel model = (PrintDevTreeModel)((Object)JsonUtil.getJsonToBean((Object)printEntity, PrintDevTreeModel.class));
            if (dicDataEntity == null) continue;
            UserEntity creatorUser = userList.stream().filter(t -> t.getId().equals(model.getCreatorUserId())).findFirst().orElse(null);
            model.setCreatorUserId(creatorUser != null ? creatorUser.getRealName() : "");
            UserEntity lastmodifyuser = userList.stream().filter(t -> t.getId().equals(model.getLastModifyUserId())).findFirst().orElse(null);
            model.setLastModifyUserId(lastmodifyuser != null ? lastmodifyuser.getRealName() : "");
            model.setParentId(dicDataEntity.getId());
            modelAll.add((Object)model);
        }
        List trees = TreeDotUtils.convertListToTreeDot(modelAll);
        List list = JsonUtil.getJsonToList((Object)trees, PrintDevVO.class);
        return list;
    }

    @Override
    public Boolean checkNameExist(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PrintDevEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(PrintDevEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperatorRecordEntity> getFlowTaskOperatorRecordList(String taskId) {
        List operatorRecordList = null;
        try {
            String sql = "SELECT * FROM flow_taskoperatorrecord WHERE F_TaskId = '?' ORDER BY F_HandleTime";
            Connection conn = ConnUtil.getConn((DataSourceMod)this.dataSourceModel);
            try {
                operatorRecordList = JdbcUtil.queryCustomMods((PreparedStatementDTO)new PreparedStatementDTO(conn, sql, new Object[]{taskId}), OperatorRecordEntity.class);
                operatorRecordList.forEach(or -> {
                    or.setHandleTime(or.getHandleTimeOrigin().getTime());
                    UserEntity userEntity = this.userService.getInfo(or.getHandleId());
                    or.setUserName(userEntity != null ? userEntity.getRealName() : "");
                });
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return operatorRecordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getDataBySql(String dbLinkId, String sqlTempLate, int type) throws Exception {
        Connection conn = null;
        try {
            conn = "0".equals(dbLinkId) ? ConnUtil.getConn((DataSourceMod)this.dataSourceModel) : ConnUtil.getConn((DataSourceMod)this.dblinkService.getInfo(dbLinkId));
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            List sqlList = JsonUtil.getJsonToList((JSONArray)JSONArray.parseArray((String)sqlTempLate));
            for (int i = 0; i < sqlList.size(); ++i) {
                List dataList = null;
                try {
                    String sql = ((Map)sqlList.get(i)).get("sql").toString();
                    dataList = JdbcUtil.queryIncludeFieldMods((PreparedStatementDTO)new PreparedStatementDTO(conn, sql));
                    if (dataList.size() == 0) {
                        dataList = JdbcUtil.queryTableFields((PreparedStatementDTO)new PreparedStatementDTO(conn, sql));
                    }
                }
                catch (DataException e) {
                    throw new Exception(MsgCode.PRI005.get().replace("{index}", Integer.toString(i + 1)) + e.getMessage());
                }
                if (i == 0) {
                    if (dataList.size() > 1) {
                        throw new Exception(MsgCode.PRI003.get());
                    }
                    if (dataList.size() == 0) {
                        throw new Exception(MsgCode.PRI004.get());
                    }
                    if (type == 1) {
                        map.put("headTable", this.getFieldMap(conn, (List)dataList.get(0)));
                        continue;
                    }
                    map.put("headTable", this.getDataMap(dataList));
                    continue;
                }
                if (type == 1) {
                    map.put("T" + i, this.getFieldMap(conn, (List)dataList.get(0)));
                    continue;
                }
                map.put("T" + i, this.getDataMap(dataList));
            }
            TreeMap<String, Object> treeMap = map;
            return treeMap;
        }
        finally {
            if (Collections.singletonList(conn).get(0) != null) {
                conn.close();
            }
        }
    }

    private List<Map<String, Object>> getDataMap(List<List<DbFieldMod>> dbJdbcModelList) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (List<DbFieldMod> mods : dbJdbcModelList) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            for (DbFieldMod mod : mods) {
                map.put(mod.getColumnLabel(), mod.getColumnValue());
            }
            mapList.add(map);
        }
        return mapList;
    }

    private List<Map<String, Object>> getFieldMap(Connection conn, List<DbFieldMod> dbJdbcModelList) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (DbFieldMod model : dbJdbcModelList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("field", model.getColumnLabel());
            String fieldComment = PrintDevUtil.compareGetColumnComment(conn, model.getTableName(), model.getColumnName());
            fieldComment = fieldComment != null ? fieldComment : "";
            map.put("fieldName", model.getColumnName() + " (" + fieldComment + ")");
            mapList.add(map);
        }
        return mapList;
    }

    public static void main(String[] args) {
        Date date = new Date();
    }
}

