package com.bringspring.system.base.controller;


import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.model.monitor.MonitorListVO;
import com.bringspring.system.base.util.MonitorUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统监控
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Api(tags = "系统监控", value = "Monitor")
@RestController
@RequestMapping("/api/system/Monitor")
public class MonitorController {

    /**
     * 系统监控
     *
     * @return ignore
     */
    @ApiOperation("系统监控")
    @GetMapping
    public ActionResult<MonitorListVO> list() {
        MonitorUtil monitorUtil = new MonitorUtil();
        MonitorListVO vo = JsonUtil.getJsonToBean(monitorUtil, MonitorListVO.class);
        vo.setTime(System.currentTimeMillis());
        return ActionResult.success(vo);
    }
}
