package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 邮件配置
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("ext_email_config")
public class EmailConfigEntity {
    /**
     * 邮件账户主键
     */
    @TableId("ID")
    private String id;

    /**
     * POP3服务
     */
    @TableField("POP3HOST")
    private String pop3Host;

    /**
     * POP3端口
     */
    @TableField("POP3PORT")
    private Integer pop3Port;

    /**
     * SMTP服务
     */
    @TableField("SMTPHOST")
    private String smtpHost;

    /**
     * SMTP端口
     */
    @TableField("SMTPPORT")
    private Integer smtpPort;

    /**
     * 账户
     */
    @TableField("ACCOUNT")
    private String account;

    /**
     * 密码
     */
    @TableField("PASSWORD")
    private String password;

    /**
     * SSL登录
     */
    @TableField("EMAIL_SSL")
    private Integer emailSsl = 0;

    /**
     * 发件人名称
     */
    @TableField("SENDERNAME")
    private String senderName;

    /**
     * 我的文件夹
     */
    @TableField("FOLDERJSON")
    private String folderJson;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;
}
