package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 消息模板表
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021年12月8日17:40:37
 */
@Data
@EqualsAndHashCode
@TableName("BASE_MESSAGE_TEMPLATE")
public class MessageTemplateEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自然主键
     */
    @TableId(value = "ID")
    private String id;

    /**
     * 编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 分类（数据字典）
     */
    @TableField(value = "CATEGORY")
    private String category;

    /**
     * 模板名称
     */
    @TableField(value = "FULL_NAME")
    private String fullName;
    /**
     * 内容
     */
    @TableField(value = "CONTENT")
    private String content;
    /**
     * 标题
     */
    @TableField(value = "TITLE")
    private String title;

    /**
     * 是否站内信
     */
    @TableField(value = "IS_STATION_LETTER")
    private Integer isStationLetter;

    /**
     * 是否邮箱
     */
    @TableField(value = "IS_EMAIL")
    private Integer isEmail;

    /**
     * 是否企业微信
     */
    @TableField(value = "IS_WE_COM")
    private Integer isWecom;

    /**
     * 是否钉钉
     */
    @TableField(value = "IS_DING_TALK")
    private Integer isDingTalk;

    /**
     * 是否短信
     */
    @TableField(value = "IS_SMS")
    private Integer isSms;

    /**
     * 短信模板ID
     */
    @TableField(value = "SMS_ID")
    private String smsId;

    /**
     * 模板参数JSON
     */
    @TableField(value = "TEMPLATE_JSON")
    private String templateJson;



    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField("LAST_MODIFY_TIME")
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

}
