package com.bringspring.system.msgcenter.model.mctaskmsgreceive;

import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.model.mctaskmsg.McTaskMsgInfoVO;
import com.bringspring.system.msgcenter.model.mctaskmsgcontent.McTaskMsgContentInfoVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.Date;

/**
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-14
 */
@Data
public class McTaskMsgReceiveInfoVO {
    /**
     * 主键
     **/
    @JsonProperty("id")
    private String id;

    /**
     * 消息id
     **/
    @JsonProperty("msgId")
    private String msgId;
    @JsonProperty("taskMsgInfo")
    private McTaskMsgInfoVO taskMsgInfo;

    /**
     * 消息模板id
     **/
    @JsonProperty("templateId")
    private String templateId;
    @JsonProperty("sendTemplateModel")
    private McMsgSendTemplateModel sendTemplateModel;

    /**
     * 消息模板id
     **/
    @JsonProperty("msgTemplateId")
    private String msgTemplateId;

    /**
     * 应用配置id
     **/
    @JsonProperty("msgAccountId")
    private String msgAccountId;

    /**
     * 消息内容id
     **/
    @JsonProperty("contentId")
    private String contentId;
    @JsonProperty("taskMsgContentInfo")
    private McTaskMsgContentInfoVO taskMsgContentInfo;

    /**
     * 消息渠道
     **/
    @JsonProperty("channelType")
    private String channelType;

    /**
     * 消息接收人
     **/
    @JsonProperty("sysUserId")
    private String sysUserId;

    /**
     * 消息接收人
     **/
    @JsonProperty("receiveUserId")
    private String receiveUserId;

    /**
     * 状态
     **/
    @JsonProperty("enabledMark")
    private String enabledMark;

    /**
     * 发送时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("sendTime")
    private Date sendTime;

    /**
     * 发送人
     **/
    @JsonProperty("sendUserId")
    private String sendUserId;

    /**
     * 重发时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("againTime")
    private Date againTime;

    /**
     * 重发人
     **/
    @JsonProperty("againUserId")
    private String againUserId;
    /**
     * 渠道消息未发出，自动重发次数
     **/
    @JsonProperty("autoAgainNum")
    private Integer autoAgainNum;
    /**
     * 渠道消息未发出，自动重发最大限制次数
     **/
    @JsonProperty("autoAgainMaxNum")
    private Integer autoAgainMaxNum;

    /**
     * 是否阅读
     **/
    @JsonProperty("isRead")
    private String isRead;

    /**
     * 阅读时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("readTime")
    private Date readTime;

    /**
     * 阅读次数
     **/
    @JsonProperty("readCount")
    private Integer readCount;

    /**
     * 描述
     **/
    @JsonProperty("description")
    private String description;

    /**
     * 创建时间
     **/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonProperty("creatorTime")
    private Date creatorTime;

    /**
     * 创建人
     **/
    @JsonProperty("creatorUserId")
    private String creatorUserId;

}