package com.bringspring.system.msgcenter.service.strategy.impl;

import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.entity.*;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import com.bringspring.system.msgcenter.util.EmailUtil;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.bringspring.system.msgcenter.constant.Constants.ReadStatus;

/**
 * 邮箱策略
 */
@Component
public class MailStrategy extends AbstractMessageChannelStrategy {
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private UserService userService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.MAIL_MSG;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg,
                               McMsgSendTemplateModel sendTemplate,
                               Map<String, McTaskMsgContentEntity> contentMap,
                               Map<String, List<McTaskMsgReceiveEntity>> receiveMap,
                               Set<String> userSet) {
        String taskMsgId = taskMsg.getId();

        String templateId = sendTemplate.getId(); // 发送配置消息模板
        String channelType = sendTemplate.getMessageType(); // 消息渠道
        String msgTemplateId = sendTemplate.getTemplateId(); // 消息模板
        String msgAccountId = sendTemplate.getAccountConfigId(); // 授权应用配置

        // 授权应用
        McMsgAccountEntity account = mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        // 消息模板
        McMsgTemplateEntity msgTemplate = mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());

        String mailKey = channelType + msgTemplateId + msgAccountId;
        // 消息内容
        McTaskMsgContentEntity mailContent;
        if (!contentMap.containsKey(mailKey)) {
            mailContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(mailKey, mailContent); // 渠道模板应用消息内容
        } else {
            mailContent = contentMap.get(mailKey);
        }

        // 消息接收人
        if (!receiveMap.containsKey(mailKey)) {
            if ("4".equals(taskMsg.getToType())) {
                List<McTaskMsgReceiveEntity> mailReceiveList =
                        packNonSystemReceive(userSet, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId
                                , mailContent.getId());
                receiveMap.put(mailKey, mailReceiveList);
            } else {
                List<McTaskMsgReceiveEntity> mailReceiveList = new ArrayList<>();
                List<UserEntity> receiveUsers = userService.getUserByIds(new ArrayList<>(userSet));
                // 接收人
                receiveUsers.stream().forEach(s -> {
                    McTaskMsgReceiveEntity receiveEntity = new McTaskMsgReceiveEntity();
                    receiveEntity.setId(RandomUtil.uuId());
                    receiveEntity.setMsgId(taskMsgId);
                    // 发送配置模板id
                    receiveEntity.setTemplateId(templateId);
                    receiveEntity.setMsgTemplateId(msgTemplateId);
                    receiveEntity.setMsgAccountId(msgAccountId);
                    receiveEntity.setContentId(mailContent.getId());
                    // 电子邮箱
                    receiveEntity.setChannelType(channelType);
                    // 下发渠道接收人：base_user主键email，系统账户邮箱
                    if (StringUtils.isNotEmpty(s.getEmail()) && EmailUtil.isEmail(s.getEmail())) {
                        receiveEntity.setReceiveUserId(s.getRealName() + "<" + s.getEmail() + ">");
                    }
                    // 冗余字段 接收人系统用户表id
                    receiveEntity.setSysUserId(s.getId());
                    receiveEntity.setEnabledMark(0); // 渠道消息下发状态，0待下发、1下/重发成功、2下/重发失败
                    receiveEntity.setIsRead(ReadStatus.UNREAD.getCode()); // 是否阅读，0否、1是
                    receiveEntity.setDescription(null);
                    mailReceiveList.add(receiveEntity);
                });
                receiveMap.put(mailKey, mailReceiveList);
            }
        }
    }

}