package com.bringspring.system.msgcenter.util;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.model.message.DingSentResult;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.taobao.api.ApiException;
import lombok.extern.slf4j.Slf4j;

import static com.bringspring.system.external.constant.DingTalkConfigConsts.TO_ALL;
import static com.bringspring.system.msgcenter.enums.ContentTypeEnum.IMG_TEXT_MSG;
import static com.bringspring.system.msgcenter.enums.ContentTypeEnum.LINK_MSG;


/**
 * 通过钉钉用户ID串进行发送消息，传入就是接收人的钉钉用户ID串
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/21 16:10
 */
@Slf4j
public class DingTalkUtil {
    // 常量定义区
    private static final String ERROR_KEY = "error";
    private static final String ACCESS_TOKEN_KEY = "access_token";
    /**
     * 钉钉发送消息的接口路径
     */
    public static final String SEND_MESSAGE = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    /**
     * 钉钉获取TOKEN的接口路径
     */
    public static final String TOKEN = "https://oapi.dingtalk.com/gettoken";

    // 私有构造函数
    private DingTalkUtil() {
        throw new UnsupportedOperationException("工具类不允许实例化");
    }

    /**
     * 获取token
     * @param appkey
     * @param appsecret
     * @return
     *
    public static String getToken (String appkey,String appsecret){
    DefaultDingTalkClient client = new
    DefaultDingTalkClient(TOKEN);
    OapiGettokenRequest request = new OapiGettokenRequest();
    request.setAppkey(appkey);
    request.setAppsecret(appsecret);
    request.setHttpMethod("GET");
    try {
    OapiGettokenResponse response = client.execute(request);
    //            LocalCacheClient.set(ACCESS_TOKEN_KEY, response.getAccessToken(),7200*1000);
    return response.getAccessToken();
    } catch (ApiException e) {
    e.printStackTrace();
    }
    return null;
    }
     */


    /**
     * 获取token
     *
     * @param appkey
     * @param appsecret
     * @return
     */
    public static JSONObject getAccessToken(String appkey, String appsecret) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", true);
        retMsg.put(ERROR_KEY, "");
        try {
            DingTalkClient client = new DefaultDingTalkClient(TOKEN);
            OapiGettokenRequest req = new OapiGettokenRequest();
            req.setAppkey(appkey);
            req.setAppsecret(appsecret);
            req.setHttpMethod("GET");
            OapiGettokenResponse rsp = client.execute(req);
            retMsg.put(ACCESS_TOKEN_KEY, rsp.getAccessToken());
            if (!rsp.isSuccess()) {
                retMsg.put("code", false);
                retMsg.put(ERROR_KEY, rsp.getErrmsg());
                retMsg.put(ACCESS_TOKEN_KEY, "");
            }
        } catch (ApiException e) {
            retMsg.put("code", false);
            retMsg.put(ERROR_KEY, e.toString());
            retMsg.put(ACCESS_TOKEN_KEY, "");
        }

        return retMsg;
    }

    /**
     * 给用户推送消息（文字消息）
     *
     * @param appkey
     * @param appsecret
     * @param agentid
     * @param userIds
     * @param content
     * @return 收到消息格式如下：
     * 发送的内容
     */
    public static DingSentResult sendDingMessage(String appkey, String appsecret, String agentid, String userIds,
                                                 McTaskMsgContentEntity content) {
        if (StringUtils.isEmpty(agentid) || StringUtils.isEmpty(userIds) || ObjectUtil.isEmpty(content)) {
            log.error("~·~·~·~执行 企业微信应用消息post下发，content 或 corpId企业id 或 touser为空~·~·~·~");
        }
        DingTalkClient client = new DefaultDingTalkClient(SEND_MESSAGE);
        /**
         * 判断是否全员发送
         */
        Boolean toUserIdAll = TO_ALL.equals(userIds); // true为全部成员，false为非全部成员
        String contentType = content.getContentType();

        OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
        request.setAgentId(Long.parseLong(agentid)); // 发送消息时使用的微应用的AgentID。
        request.setUseridList(userIds); // 接收者的userid列表，最大用户列表长度100。
        request.setToAllUser(toUserIdAll); // 是否发送给企业全部用户。

        OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
        if (LINK_MSG.getCode().equals(contentType) ) {
            msg.setActionCard(new OapiMessageCorpconversationAsyncsendV2Request.ActionCard());
            msg.setMsgtype("action_card"); // 卡片消息
            msg.getActionCard().setTitle(content.getTitle());
            msg.getActionCard().setMarkdown(content.getContent());
            msg.getActionCard().setSingleTitle("查看详情");
            msg.getActionCard().setSingleUrl(content.getLinkUrl());
        } else if (IMG_TEXT_MSG.getCode().equals(contentType)) {
            msg.setMsgtype("link"); // 链接消息
            msg.setLink(new OapiMessageCorpconversationAsyncsendV2Request.Link());
            msg.getLink().setTitle(content.getTitle());
            msg.getLink().setText(content.getContent());
            msg.getLink().setMessageUrl(content.getLinkUrl());
            msg.getLink().setPicUrl(content.getPicUrl());
        } else {
            msg.setMsgtype("text"); // 文本消息
            msg.setText(new OapiMessageCorpconversationAsyncsendV2Request.Text());
            String randomCode = "随机验证码：" + RandomUtil.uuId();
            msg.getText().setContent(content.getContent() + randomCode);
        }
        request.setMsg(msg);

        DingSentResult dingSentResult = new DingSentResult();
        dingSentResult.setMsgId(content.getMsgId());
        try {
            JSONObject retMsg = getAccessToken(appkey, appsecret);
            if (retMsg.getBoolean("code")) {
                OapiMessageCorpconversationAsyncsendV2Response response = client.execute(request, retMsg.getString(
                        ACCESS_TOKEN_KEY));
                if (response.getErrcode() > 0) {
                    dingSentResult.setErrCode(false);
                    dingSentResult.setErrMsg(response.getErrmsg());
                    dingSentResult.setFailUser(userIds);
                } else {
                    dingSentResult.setErrCode(true);
                    dingSentResult.setErrMsg("");
                }
            } else {
                dingSentResult.setErrCode(false);
                dingSentResult.setErrMsg("获取token失败:" + retMsg.getString(ERROR_KEY));
                dingSentResult.setFailUser(userIds);
            }
            return dingSentResult;
        } catch (ApiException e) {
            dingSentResult.setErrCode(false);
            dingSentResult.setErrMsg(e.toString());
            dingSentResult.setFailUser(userIds);
            return dingSentResult;
        }
    }

}
