package com.bringspring.system.permission.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.SumTree;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.constant.PermissionConst;
import com.bringspring.system.permission.entity.*;
import com.bringspring.system.permission.model.permission.PermissionModel;
import com.bringspring.system.permission.model.position.*;
import com.bringspring.system.permission.service.*;
import com.bringspring.system.permission.util.PermissionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 岗位信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Api(tags = "岗位管理", value = "Position")
@RestController
@RequestMapping("/api/permission/Position")
public class PositionController {
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private OrganizeRelationService organizeRelationService;

    /**
     * 获取岗位管理信息列表
     *
     * @param paginationPosition
     * @return
     */
    @ApiOperation("获取岗位列表（分页）")
    @GetMapping
    public ActionResult<PageListVO<PositionListVO>> list(PaginationPosition paginationPosition) {
        List<OrganizeEntity> list =
                organizeService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List<PositionEntity> data = positionService.getList(paginationPosition);
        //添加部门信息，部门映射到organizeId
        List<PositionListVO> voList = JsonUtil.getJsonToList(data, PositionListVO.class);
        //添加部门信息
        for (PositionListVO entity1 : voList) {
            OrganizeEntity entity =
                    list.stream().filter(t -> t.getId().equals(entity1.getOrganizeId())).findFirst().orElse(new OrganizeEntity());
            if (entity1.getOrganizeId().equals(entity.getId())) {
                entity1.setDepartment(entity.getFullName());
            }
            entity1.setDepartment(PermissionUtil.getLinkInfoByOrgId(entity1.getOrganizeId(), organizeService, false));
        }
        //将type成中文名
        List<DictionaryDataEntity> dictionaryDataEntities = dictionaryDataService.getList(
                "dae93f2fd7cd4df999d32f8750fa6a1e", false);
        for (PositionListVO entity1 : voList) {
            DictionaryDataEntity entity =
                    dictionaryDataEntities.stream().filter(t -> t.getEnCode().equals(entity1.getType())).findFirst().orElse(null);
            if (entity != null) {
                entity1.setType(entity.getFullName());
            }
        }
        PaginationVO paginationVO = JsonUtil.getJsonToBean(paginationPosition, PaginationVO.class);
        return ActionResult.page(voList, paginationVO);
    }

    /**
     * 获取数据权限岗位管理信息列表
     *
     * @param paginationPosition
     * @return
     */
    @ApiOperation("获取岗位列表（分页）")
    @GetMapping("/positionDataPermission")
    public ActionResult<PageListVO<PositionListVO>> listDataPermission(PaginationPosition paginationPosition) {
        List<OrganizeEntity> list =
                organizeService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
//        获取数据权限方法
        List<PositionEntity> data = positionService.getListPositionDataPermission(paginationPosition);
        //添加部门信息，部门映射到organizeId
        List<PositionListVO> voList = JsonUtil.getJsonToList(data, PositionListVO.class);
        //添加部门信息
        for (PositionListVO entity1 : voList) {
            OrganizeEntity entity =
                    list.stream().filter(t -> t.getId().equals(entity1.getOrganizeId())).findFirst().orElse(new OrganizeEntity());
            if (entity1.getOrganizeId().equals(entity.getId())) {
                entity1.setDepartment(entity.getFullName());
            }
            entity1.setDepartment(PermissionUtil.getLinkInfoByOrgId(entity1.getOrganizeId(), organizeService, false));
        }
        //将type成中文名
        List<DictionaryDataEntity> dictionaryDataEntities = dictionaryDataService.getList(
                "dae93f2fd7cd4df999d32f8750fa6a1e", false);
        for (PositionListVO entity1 : voList) {
            DictionaryDataEntity entity =
                    dictionaryDataEntities.stream().filter(t -> t.getEnCode().equals(entity1.getType())).findFirst().orElse(null);
            if (entity != null) {
                entity1.setType(entity.getFullName());
            }
        }
        PaginationVO paginationVO = JsonUtil.getJsonToBean(paginationPosition, PaginationVO.class);
        return ActionResult.page(voList, paginationVO);
    }

    /**
     * 岗位类型和岗位树状图
     *
     * @return
     */
    @ApiOperation("岗位类型和岗位树状图")
    @GetMapping("/positionTree")
    public ActionResult<ListVO<PositionSelectorVO>> positionTree() {
        List<PositionEntity> list =
                positionService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());

        List<PosOrgModel> positionList = new ArrayList<>();
        positionList = JsonUtil.getJsonToList(list, PosOrgModel.class);
        List<DictionaryDataEntity> positionType = dictionaryDataService.getList("dae93f2fd7cd4df999d32f8750fa6a1e");
        List<PosOrgModel> positionParentList = JsonUtil.getJsonToList(positionType, PosOrgModel.class);
//        List<PositionSelectorVO> positionTypeList = new ArrayList<>();
        positionList.stream().forEach(v -> {
            List<DictionaryDataEntity> collectParent =
                    positionType.stream().filter(j -> j.getEnCode().equals(v.getType())).collect(Collectors.toList());
            v.setType("position");
            if (!ObjectUtil.isEmpty(collectParent)) {
                v.setParentId(collectParent.get(0).getId());
            }
        });
        positionList.addAll(positionParentList);
        List<SumTree<PosOrgModel>> trees = TreeDotUtils.convertListToTreeDot(positionList);
        List<PositionSelectorVO> jsonToList1 = JsonUtil.getJsonToList(trees, PositionSelectorVO.class);
        ListVO<PositionSelectorVO> vo = new ListVO<>();
        vo.setList(jsonToList1);
        return ActionResult.success(vo);
    }

    /**
     * 列表
     *
     * @return
     */
    @ApiOperation("列表")
    @GetMapping("/All")
    public ActionResult<ListVO<PositionListAllVO>> listAll() {
        List<PositionEntity> list =
                positionService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List<PositionListAllVO> vos = JsonUtil.getJsonToList(list, PositionListAllVO.class);
        ListVO<PositionListAllVO> vo = new ListVO<>();
        vo.setList(vos);
        return ActionResult.success(vo);
    }

    /**
     * 树形（机构+岗位）
     *
     * @return
     */
    @ApiOperation("获取岗位下拉列表（公司+部门+岗位）")
    @GetMapping("/Selector")
    public ActionResult selector() {
        List<PositionEntity> list1 = positionService.getList();
        List<OrganizeEntity> list2 = organizeService.getList();
        List<PosOrgModel> posList = new ArrayList<>();
        for (PositionEntity entity : list1) {
            PosOrgModel posOrgModel = JsonUtil.getJsonToBean(entity, PosOrgModel.class);
            posOrgModel.setParentId(entity.getOrganizeId());
            posOrgModel.setType("position");
            posOrgModel.setIcon("icon-ym icon-ym-tree-position1");
            posList.add(posOrgModel);
        }
        List<PosOrgModel> orgList = JsonUtil.getJsonToList(list2, PosOrgModel.class);
        for (PosOrgModel entity1 : orgList) {
            if ("department".equals(entity1.getType())) {
                entity1.setIcon("icon-ym icon-ym-tree-department1");
            } else if ("company".equals(entity1.getType())) {
                entity1.setIcon("icon-ym icon-ym-tree-organization3");
            }
        }
        JSONArray objects = ListToTreeUtil.treeWhere(posList, orgList);
        List<PosOrgModel> jsonToList = JsonUtil.getJsonToList(objects, PosOrgModel.class);

        List<PosOrgModel> list = new ArrayList<>(16);
        // 得到角色的值
        List<PosOrgModel> collect =
                jsonToList.stream().filter(t -> "position".equals(t.getType())).sorted(Comparator.comparing(PosOrgModel::getSortCode)).collect(Collectors.toList());
        list.addAll(collect);
        jsonToList.removeAll(collect);
        List<PosOrgModel> collect1 =
                jsonToList.stream().sorted(Comparator.comparing(PosOrgModel::getSortCode).thenComparing(PosOrgModel::getCreatorTime, Comparator.reverseOrder())).collect(Collectors.toList());
        list.addAll(collect1);

        List<SumTree<PosOrgModel>> trees = TreeDotUtils.convertListToTreeDot(list);
        List<PositionSelectorVO> jsonToList1 = JsonUtil.getJsonToList(trees, PositionSelectorVO.class);
        ListVO vo = new ListVO();
        vo.setList(jsonToList1);
        return ActionResult.success(vo);
    }

    /**
     * 通过组织id获取岗位列表
     *
     * @param organizeId 主键值
     * @return
     */
    @ApiOperation("通过组织id获取岗位列表")
    @GetMapping("/getList/{organizeId}")
    public ActionResult<List<PositionVo>> getListByOrganizeId(@PathVariable("organizeId") String organizeId) {
        List<PositionEntity> list = positionService.getListByOrganizeId(organizeId);
        List<PositionVo> jsonToList = JsonUtil.getJsonToList(list, PositionVo.class);
        return ActionResult.success(jsonToList);
    }

    /**
     * 获取岗位管理信息
     *
     * @param id 主键值
     * @return
     */
    @ApiOperation("获取岗位管理信息")
    @GetMapping("/{id}")
    public ActionResult<PositionInfoVO> getInfo(@PathVariable("id") String id) throws DataException {
        PositionEntity entity = positionService.getInfo(id);
        PositionInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, PositionInfoVO.class);
        if (!ObjectUtil.isEmpty(vo.getOrganizeId())) {
            vo.setOrganizeName(organizeService.getInfo(vo.getOrganizeId()).getFullName());
        }
        return ActionResult.success(vo);
    }


    /**
     * 新建岗位管理
     *
     * @param positionCrForm 实体对象
     * @return
     */
    @ApiOperation("新建岗位管理")
    @PostMapping
    public ActionResult create(@RequestBody @Valid PositionCrForm positionCrForm) {
        PositionEntity entity = JsonUtil.getJsonToBean(positionCrForm, PositionEntity.class);
        if (positionService.isExistByFullName(entity, false)) {
            return ActionResult.fail("岗位名称不能重复");
        }
        if (positionService.isExistByEnCode(entity, false)) {
            return ActionResult.fail("岗位编码不能重复");
        }
        // 设置岗位id
        entity.setId(RandomUtil.uuId());
        createOrganizeRoleRelation(entity.getOrganizeId(), entity.getId());
        positionService.create(entity);
        return ActionResult.success(MsgCode.SU001.get());
    }

    /**
     * 更新岗位管理
     *
     * @param id             主键值
     * @param positionUpForm 实体对象
     * @return
     */
    @ApiOperation("更新岗位管理")
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id, @RequestBody @Valid PositionUpForm positionUpForm) {
        // 当岗位绑定用户不让其更改
        if (userRelationService.existByObjectId(id, PermissionConst.POSITION)) {
            if (!positionService.getInfo(id).getOrganizeId().equals(positionUpForm.getOrganizeId())) {
                return ActionResult.fail(MsgCode.FA023.get());
            }
        }
        PositionEntity entity = JsonUtil.getJsonToBean(positionUpForm, PositionEntity.class);
        entity.setId(id);
        if (positionService.isExistByFullName(entity, true)) {
            return ActionResult.fail("岗位名称不能重复");
        }
        if (positionService.isExistByEnCode(entity, true)) {
            return ActionResult.fail("岗位编码不能重复");
        }
        createOrganizeRoleRelation(entity.getOrganizeId(), id);
        boolean flag = positionService.update(id, entity);
        if (flag == false) {
            return ActionResult.fail(MsgCode.FA002.get());
        }
        return ActionResult.success(MsgCode.SU004.get());
    }

    /**
     * 删除岗位管理
     *
     * @param id 主键值
     * @return
     */
    @ApiOperation("删除岗位管理")
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        // 当岗位绑定用户不让其更改
        if (userRelationService.existByObjectId(id, PermissionConst.POSITION)) {
            return ActionResult.fail(MsgCode.FA024.get());
        }
        PositionEntity entity = positionService.getInfo(id);
        if (entity != null) {
            List<UserRelationEntity> userRelList = userRelationService.getListByObjectId(id);
            if (userRelList.size() > 0) {
                return ActionResult.fail("该岗位下有用户");
            }
            for (UserRelationEntity entity1 : userRelList) {
                UserEntity entity2 = userService.getById(entity1.getUserId());
                if (entity2 != null) {
                    String newPositionId = entity2.getPositionId().replace(id, "");
                    if (entity2.getPositionId().contains(id)) {
                        if (newPositionId.length() != 0 && newPositionId.substring(0, 1) == ",") {
                            entity2.setPositionId(newPositionId.substring(1));
                        } else if (newPositionId.length() != 0) {
                            entity2.setPositionId(newPositionId.replace(",,", ","));
                        }
                    }
                }
            }
            userRelationService.deleteAllByObjId(id);

            // 删除岗位与组织之间的关联数据
            QueryWrapper<OrganizeRelationEntity> query = new QueryWrapper<>();
            query.lambda().eq(OrganizeRelationEntity::getObjectType, PermissionConst.POSITION);
            query.lambda().eq(OrganizeRelationEntity::getObjectId, id);
            organizeRelationService.remove(query);

            positionService.delete(entity);
            return ActionResult.success(MsgCode.SU003.get());
        }
        return ActionResult.fail(MsgCode.FA003.get());
    }

    /**
     * 更新菜单状态
     *
     * @param id 主键值
     * @return
     */
    @ApiOperation("更新菜单状态")
    @PutMapping("/{id}/Actions/State")
    public ActionResult upState(@PathVariable("id") String id) {
        PositionEntity entity = positionService.getInfo(id);
        if (entity != null) {
            if (entity.getEnabledMark() == null || "1".equals(String.valueOf(entity.getEnabledMark()))) {
                entity.setEnabledMark(0);
            } else {
                entity.setEnabledMark(1);
            }
            positionService.update(id, entity);
            return ActionResult.success(MsgCode.SU004.get());
        }
        return ActionResult.fail("MsgCode.UPDATE_FAIL_NOT_EXISTS");
    }

    /**
     * 通过组织id获取岗位列表
     *
     * @param organizeIds 组织id数组
     * @return 岗位列表
     */
    @ApiOperation("获取岗位列表通过组织id数组")
    @PostMapping("/getListByOrgIds")
    public ActionResult<ListVO<PermissionModel>> getListByOrganizeIds(@RequestBody @Valid Map<String, List<String>> organizeIds) {
        List<PermissionModel> PositionModelAll = new LinkedList<>();
        for (String organizeId : organizeIds.get("organizeIds")) {
            OrganizeEntity info = organizeService.getInfo(organizeId);
            if (info != null) {
                PermissionModel parentModel = new PermissionModel();
                List<PositionEntity> list = positionService.getListByOrganizeId(organizeId);
                List<PermissionModel> positionModels = JsonUtil.getJsonToList(list, PermissionModel.class);
                parentModel.setHasChildren(true);
                parentModel.setFullName(info.getFullName());
                parentModel.setId(info.getId());
                parentModel.setChildren(positionModels);
                PositionModelAll.add(parentModel);
            }
        }
        ListVO vo = new ListVO();
        vo.setList(PositionModelAll);
        return ActionResult.success(vo);


    }

    /**
     * 添加组织角色关联关系
     *
     * @param organizeId 组织id
     * @param positionId 岗位id
     */
    private void createOrganizeRoleRelation(String organizeId, String positionId) {
        // 清除之前的关联关系
        QueryWrapper<OrganizeRelationEntity> query = new QueryWrapper<>();
        query.lambda().eq(OrganizeRelationEntity::getObjectType, PermissionConst.POSITION);
        query.lambda().eq(OrganizeRelationEntity::getObjectId, positionId);
        organizeRelationService.remove(query);
        // 添加与组织的关联关系
        OrganizeRelationEntity organizeRelationEntity = new OrganizeRelationEntity();
        organizeRelationEntity.setId(RandomUtil.uuId());
        organizeRelationEntity.setOrganizeId(organizeId);
        organizeRelationEntity.setObjectType(PermissionConst.POSITION);
        organizeRelationEntity.setObjectId(positionId);
        organizeRelationService.save(organizeRelationEntity);
    }


}
