package com.bringspring.system.permission.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * 组织机构
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("BASE_ORGANIZE")
public class OrganizeEntity extends PermissionEntityBase implements Serializable {

    /**
     * 机构上级
     */
    @TableField("PARENT_ID")
    private String parentId;

    @TableId("id")
    private String id;

    /**
     * 名称
     */
    @TableField("FULL_NAME")
    private String fullName;
    /**
     * 简称
     */
    @TableField("short_name")
    private String shortName;

    /**
     * 机构分类
     */
    @TableField("CATEGORY")
    private String category;

    /**
     * 机构主管
     */
    @TableField("MANAGER_ID")
    private String managerId;
    /**
     * 父级组织
     */
    @TableField("ORGANIZE_ID_TREE")
    private String organizeIdTree;

    /**
     * 直属父级组织
     */
    @TableField("ORGANIZE_ID")
    private String organizeId;

    /**
     * 有效标识  1正常  0禁用
     */
    @TableField("enabled_mark")
    private Integer enabledMark;


}
