package com.bringspring.system.permission.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 组织关系
 * </p>
 *
 * @author YanYu
 * @since 2022-01-19
 */
@Data
@TableName("BASE_POSITION_RELATION")
@ApiModel(value = "base_position_relation对象", description = "岗位关系")
public class PositionRelationEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自然主键
     */
    @TableId("ID")
    private String id;

    /**
     *
     */
    @TableField("POSITION_ID")
    private String positionId;

    /**
     * 对象类型（角色：Role）
     */
    @TableField("OBJECT_TYPE")
    private String objectType;

    /**
     * 对象主键
     */
    @TableField("OBJECT_ID")
    private String objectId;

    /**
     * 创建时间
     */
    @TableField("CREATOR_TIME")
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField("CREATOR_USER_ID")
    private String creatorUserId;

}
