package com.bringspring.system.permission.model.organize;

import com.bringspring.common.base.Pagination;
import com.bringspring.system.permission.constant.PermissionConst;
import lombok.Data;

/**
 * 组织机构表查询
 */
@Data
public class OrganizePagination extends Pagination {
    /**
     * 菜单ID用于数据权限
     */
    private String menuId;

    /**
     * 查询类型 公司(company)\部门（department）
     * PermissionConst.COMPANY
     */
    private String type;

    public OrganizePagination() {
    }

    public OrganizePagination(String menuId) {
        this.menuId = menuId;
    }

    public OrganizePagination(String menuId, String type) {
        this.menuId = menuId;
        this.type = type;
    }
}
