package com.bringspring.system.permission.service.strategy;

import java.util.List;
import java.util.Map;

/**
 * 策略接口(抽象策略类)：
 * 定义：定义所有支持的算法的公共接口。
 * 角色：作为所有具体策略类的父接口，确保它们具有一致的方法签名。
 * 职责：定义算法的接口，并由子类实现。
 * <p>
 * 数据权限-条件内容策略接口
 *
 * 继承抽象类，实现具体策略方法。
 * 定义字段内容选项、格式化选项、符号选项属性。
 * 注意：实现类要spring注入、和条件内容条件符号的redis缓存。
 */
public abstract class FieldContentNumberStrategy {

    /**
     * 策略属性：策略顺序
     */
    public Integer order = Integer.MAX_VALUE;
    /**
     * 策略属性：字段内容选项
     */
    public List<Map<String, Object>> conditionOptions = null;
    /**
     * 策略属性：符号选项
     */
    public List<Map<String, Object>> symbolOptions = null;

    public Integer getOrder() {
        return order;
    }

    public List<Map<String, Object>> getConditionOptions() {
        return conditionOptions;
    }

    public List<Map<String, Object>> getSymbolOptions() {
        return symbolOptions;
    }

    /**
     * 策略方法：根据条件模型生成查询条件
     *
     * @param fieldContent
     * @return
     */
    public abstract Object convertFieldContent(String fieldContent, String symbol);

}
