/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.system.base.model.cachemanage.CacheManageInfoVO;
import com.bringspring.system.base.model.cachemanage.CacheManageListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f13\u5b58\u7ba1\u7406"}, value="CacheManage")
@RestController
@RequestMapping(value={"/api/system/CacheManage"})
public class CacheManageController {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private UserProvider userProvider;

    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58\u5217\u8868")
    @GetMapping
    public ActionResult<ListVO<CacheManageListVO>> getList(Page page) {
        String tenantId = this.userProvider.get().getTenantId();
        List<CacheManageListVO> list = this.getAllList(tenantId);
        if (StringUtils.isNotEmpty((String)page.getKeyword())) {
            list = list.stream().filter(t -> t.getName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        ListVO vo = new ListVO();
        vo.setList(list);
        return ActionResult.success((Object)vo);
    }

    private List<CacheManageListVO> getAllList(String tenantId) {
        ArrayList<CacheManageListVO> list = new ArrayList();
        Set data = this.cacheUtil.getAllKeys();
        for (String key : data) {
            try {
                CacheManageListVO model;
                int cacheSize = 0;
                Object value = this.cacheUtil.query(key);
                if (ObjectUtil.isNotEmpty((Object)value)) {
                    cacheSize = String.valueOf(value).getBytes().length;
                }
                if (!StringUtils.isEmpty((String)tenantId) && key.contains(tenantId)) {
                    model = new CacheManageListVO();
                    model.setName(key);
                    model.setCacheSize(cacheSize);
                    model.setOverdueTime(this.cacheUtil.getLiveTime(key));
                    list.add(model);
                    continue;
                }
                if (!StringUtils.isEmpty((String)tenantId)) continue;
                model = new CacheManageListVO();
                model.setName(key);
                model.setCacheSize(cacheSize);
                model.setOverdueTime(this.cacheUtil.getLiveTime(key));
                list.add(model);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        list = list.stream().sorted(Comparator.comparing(CacheManageListVO::getOverdueTime)).collect(Collectors.toList());
        return list;
    }

    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58\u4fe1\u606f")
    @GetMapping(value={"/{name}"})
    public ActionResult info(@PathVariable(value="name") String name) {
        name = XSSEscape.escape((String)name);
        String json = String.valueOf(this.cacheUtil.query(name));
        CacheManageInfoVO vo = new CacheManageInfoVO();
        vo.setName(name);
        vo.setValue(json);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u6e05\u7a7a\u6240\u6709\u7f13\u5b58")
    @PostMapping(value={"/Actions/ClearAll"})
    public ActionResult clearAll() {
        String tenantId = this.userProvider.get().getTenantId();
        if ("".equals(tenantId)) {
            Set keys = this.cacheUtil.getAllKeys();
            for (String key : keys) {
                this.cacheUtil.remove(key);
            }
        } else {
            Set data = this.cacheUtil.getAllKeys();
            for (String key : data) {
                if (!key.contains(tenantId)) continue;
                this.cacheUtil.remove(key);
            }
        }
        return ActionResult.success((String)"\u6e05\u7406\u6210\u529f");
    }

    @ApiOperation(value="\u6e05\u7a7a\u5355\u4e2a\u7f13\u5b58")
    @DeleteMapping(value={"/{name}"})
    public ActionResult clear(@PathVariable(value="name") String name) {
        this.cacheUtil.remove(name);
        return ActionResult.success((String)"\u6e05\u7a7a\u6210\u529f");
    }

    @ApiOperation(value="\u6761\u4ef6\u5220\u9664\u7f13\u5b58")
    @GetMapping(value={"/Actions/searchDelete"})
    public ActionResult batchDelete(Page page) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        if (StringUtils.isNotEmpty((String)page.getKeyword())) {
            String tenantId = userInfo.getTenantId();
            List<CacheManageListVO> list = this.getAllList(tenantId);
            if (CollectionUtil.isNotEmpty(list = list.stream().filter(t -> t.getName().contains(page.getKeyword())).collect(Collectors.toList()))) {
                list.stream().forEach(t -> this.cacheUtil.remove(t.getName()));
            }
        }
        return ActionResult.success((String)"\u6279\u91cf\u5220\u9664\u6210\u529f");
    }
}

