/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcOriginUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.system.base.service.DbSyncService;
import com.bringspring.system.base.service.DbTableService;
import com.bringspring.system.base.service.DblinkService;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DbSyncServiceImpl
implements DbSyncService {
    private static final Logger log = LoggerFactory.getLogger(DbSyncServiceImpl.class);
    @Autowired
    private DblinkService dblinkService;
    @Autowired
    private DbTableService dbTableService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer checkExecute(String dbLinkIdFrom, String dbLinkIdTo, String table) throws Exception {
        DbLinkEntity linkFrom = this.dblinkService.getInfo(dbLinkIdFrom);
        DbLinkEntity linkTo = this.dblinkService.getInfo(dbLinkIdTo);
        if (dbLinkIdFrom.equals(dbLinkIdTo) || (linkFrom.getHost() + linkFrom.getPort() + linkFrom.getDbName()).equals(linkTo.getHost() + linkTo.getPort() + linkTo.getDbName())) {
            return -1;
        }
        Connection connFrom = ConnUtil.getConn((DataSourceMod)linkFrom);
        try {
            Integer n;
            block17: {
                Connection connTo;
                block15: {
                    Integer n2;
                    block16: {
                        block13: {
                            Integer n3;
                            block14: {
                                connTo = ConnUtil.getConn((DataSourceMod)linkTo);
                                try {
                                    if (this.dbTableService.getList(linkTo.getId()).stream().filter(tableOne -> tableOne.getTable().equals(table)).count() != 0L) break block13;
                                    n3 = 2;
                                    if (Collections.singletonList(connTo).get(0) == null) break block14;
                                }
                                catch (Throwable throwable) {
                                    if (Collections.singletonList(connTo).get(0) != null) {
                                        connTo.close();
                                    }
                                    throw throwable;
                                }
                                connTo.close();
                            }
                            return n3;
                        }
                        String toSql = "SELECT count(*) AS CREATOR_TIMECOUNT FROM ?;";
                        if (JdbcUtil.queryOneInt((PreparedStatementDTO)new PreparedStatementDTO(connTo, toSql), (String)"CREATOR_TIMECOUNT") <= 0) break block15;
                        n2 = 3;
                        if (Collections.singletonList(connTo).get(0) == null) break block16;
                        connTo.close();
                    }
                    return n2;
                }
                this.syncTable(connFrom, connTo, table);
                n = 0;
                if (Collections.singletonList(connTo).get(0) == null) break block17;
                connTo.close();
            }
            return n;
        }
        finally {
            if (Collections.singletonList(connFrom).get(0) != null) {
                connFrom.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeImport(String dbLinkIdFrom, String dbLinkIdTo, String table) throws Exception {
        Connection connFrom = ConnUtil.getConn((DataSourceMod)this.dblinkService.getInfo(dbLinkIdFrom));
        try {
            Connection connTo = ConnUtil.getConn((DataSourceMod)this.dblinkService.getInfo(dbLinkIdTo));
            try {
                SqlBase sqlBase = DbTypeUtil.getDb((Connection)connTo).getSqlBase();
                JdbcUtil.creUpDe((PreparedStatementDTO)sqlBase.getDeleteSqlPSD(connTo, table));
                DbBase dbBase = DbTypeUtil.getDb((Connection)connTo);
                JdbcUtil.creUpDeBatch((Connection)connTo, (List)sqlBase.getCreateTablePSD(table, JdbcOriginUtil.getTableInfo((Connection)connFrom, (String)table).getComment(), JdbcOriginUtil.getFields((Connection)connFrom, (String)table), dbBase));
                this.syncTable(connFrom, connTo, table);
            }
            finally {
                if (Collections.singletonList(connTo).get(0) != null) {
                    connTo.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(connFrom).get(0) != null) {
                connFrom.close();
            }
        }
    }

    private void syncTable(Connection connFrom, Connection connTo, String table) throws DataException {
        String fromSql = "SELECT * FROM " + table;
        List dataList = JdbcUtil.queryIncludeFieldMods((PreparedStatementDTO)new PreparedStatementDTO(connFrom, fromSql));
        if (dataList.size() > 0) {
            String sqlData = DbTypeUtil.getDb((Connection)connTo).getSqlBase().batchInsertSql(dataList, table);
            JdbcUtil.creUpDe((PreparedStatementDTO)new PreparedStatementDTO(connTo, sqlData));
        }
    }
}

