/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.mapper.MessageTemplateMapper;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.message.util.SentMessageUtil;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageTemplateServiceImpl
extends ServiceImpl<MessageTemplateMapper, MessageTemplateEntity>
implements MessageTemplateService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SentMessageUtil sentMessageUtil;
    @Autowired
    private SysConfigService sysConfigService;

    @Override
    public List<MessageTemplateEntity> getSelector(Pagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            try {
                String decode = URLDecoder.decode(pagination.getKeyword(), "UTF-8");
                queryWrapper.lambda().and(t -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(MessageTemplateEntity::getFullName, (Object)decode)).or()).like(MessageTemplateEntity::getTitle, (Object)pagination.getKeyword())).or()).like(MessageTemplateEntity::getEnCode, (Object)pagination.getKeyword());
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        queryWrapper.lambda().eq(MessageTemplateEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().orderByDesc(MessageTemplateEntity::getCreatorTime);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<MessageTemplateEntity> getList(Pagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            try {
                String decode = URLDecoder.decode(pagination.getKeyword(), "UTF-8");
                queryWrapper.lambda().and(t -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(MessageTemplateEntity::getFullName, (Object)decode)).or()).like(MessageTemplateEntity::getTitle, (Object)pagination.getKeyword())).or()).like(MessageTemplateEntity::getEnCode, (Object)pagination.getKeyword());
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        queryWrapper.lambda().orderByDesc(MessageTemplateEntity::getCreatorTime);
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public MessageTemplateEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MessageTemplateEntity::getId, (Object)id);
        return (MessageTemplateEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(MessageTemplateEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    @DSTransactional
    public boolean update(String id, MessageTemplateEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void delete(MessageTemplateEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MessageTemplateEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(MessageTemplateEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(MessageTemplateEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void testSendMessage(SentMessageForm messageTemplateCrForm) throws Exception {
        ArrayList<String> userId = new ArrayList<String>();
        UserInfo userInfo = this.userProvider.get();
        userId.add(userInfo.getUserId());
        messageTemplateCrForm.setToUserIds(userId);
        messageTemplateCrForm.setType(3);
        messageTemplateCrForm.setBodyText(new HashMap<String, String>());
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        JSONObject map = JSONObject.parseObject((String)messageTemplateCrForm.getTemplateJson());
        parameterMap.putAll((Map<String, String>)map);
        parameterMap.put("AppUrl", this.sysConfigService.getConfigByKeyName("qyhMobileUrl").getKeyValue());
        messageTemplateCrForm.setParameterMap(parameterMap);
        this.sentMessageUtil.sendMessage(messageTemplateCrForm);
    }

    @Override
    public MessageTemplateEntity getMessageTemplateByEncode(String encode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)encode);
        return (MessageTemplateEntity)this.getOne((Wrapper)queryWrapper);
    }
}

