/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.util;

import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;

public class DingTalkUtil {
    public static final String SEND_MESSAGE = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    public static final String TOKEN = "https://oapi.dingtalk.com/gettoken";

    public static JSONObject getAccessToken(String appkey, String appsecret) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"");
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient(TOKEN);
            OapiGettokenRequest req = new OapiGettokenRequest();
            req.setAppkey(appkey);
            req.setAppsecret(appsecret);
            req.setHttpMethod("GET");
            OapiGettokenResponse rsp = (OapiGettokenResponse)client.execute((TaobaoRequest)req);
            retMsg.put("access_token", (Object)rsp.getAccessToken());
            if (!rsp.isSuccess()) {
                retMsg.put("code", (Object)false);
                retMsg.put("error", (Object)rsp.getErrmsg());
                retMsg.put("access_token", (Object)"");
            }
        }
        catch (ApiException e) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)e.toString());
            retMsg.put("access_token", (Object)"");
        }
        return retMsg;
    }

    public static JSONObject sendDingMessage(String appkey, String appsecret, String agentid, String userIds, String content, String title) {
        JSONObject retMsg = new JSONObject();
        DefaultDingTalkClient client = new DefaultDingTalkClient(SEND_MESSAGE);
        OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
        request.setUseridList(userIds);
        request.setAgentId(Long.valueOf(Long.parseLong(agentid)));
        request.setToAllUser(Boolean.valueOf(false));
        OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
        msg.setMsgtype("markdown");
        msg.setText(new OapiMessageCorpconversationAsyncsendV2Request.Text());
        OapiMessageCorpconversationAsyncsendV2Request.Markdown markdown = new OapiMessageCorpconversationAsyncsendV2Request.Markdown();
        markdown.setTitle(title);
        markdown.setText(content);
        msg.setMarkdown(markdown);
        msg.getText().setContent(content);
        request.setMsg(msg);
        try {
            retMsg = DingTalkUtil.getAccessToken(appkey, appsecret);
            if (retMsg.getBoolean("code").booleanValue()) {
                OapiMessageCorpconversationAsyncsendV2Response response = (OapiMessageCorpconversationAsyncsendV2Response)client.execute((TaobaoRequest)request, retMsg.getString("access_token"));
                if (response.getErrcode() > 0L) {
                    retMsg.put("code", (Object)false);
                    retMsg.put("error", (Object)response.getErrmsg());
                } else {
                    retMsg.put("code", (Object)true);
                    retMsg.put("error", (Object)"");
                }
            } else {
                retMsg.put("code", (Object)false);
                retMsg.put("error", (Object)("\u83b7\u53d6token\u5931\u8d25:" + retMsg.getString("error")));
            }
            return retMsg;
        }
        catch (ApiException e) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)e.toString());
            return retMsg;
        }
    }
}

