/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.chain;

import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.service.chain.FilterProcessor;
import com.bringspring.system.msgcenter.service.context.FilterResult;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class FilterChain {
    private final List<FilterProcessor> processors;

    public FilterChain(List<FilterProcessor> processors) {
        this.processors = processors;
    }

    public void process(SendMessageContext context) {
        List<McTaskMsgReceiveEntity> currentValid = context.getReceiveList();
        for (FilterProcessor processor : this.processors) {
            FilterResult result = processor.process(context);
            context.getInvalidList().addAll(result.getInvalid());
            currentValid = result.getValid();
            if (currentValid.isEmpty()) break;
            context.setValidList(currentValid);
        }
        context.setValidList(currentValid);
    }
}

