/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.enums.MsgCenterCode;
import com.bringspring.system.msgcenter.enums.ToTypeEnum;
import com.bringspring.system.msgcenter.exception.SendMessageException;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McBusinessService;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgcenter.service.chain.ChainChannelType;
import com.bringspring.system.msgcenter.service.chain.FilterChain;
import com.bringspring.system.msgcenter.service.chain.FilterChainFactory;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import com.bringspring.system.msgcenter.service.strategy.MessageSender;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMessageSender
implements MessageSender {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageSender.class);
    @Autowired
    protected McBusinessService mcBusinessService;
    @Autowired
    protected McMsgTemplateService mcMsgTemplateService;
    @Autowired
    protected McMsgAccountService mcMsgAccountService;
    @Autowired
    protected SynThirdInfoService synThirdInfoService;
    @Autowired
    protected McTaskMsgReceiveService mcTaskMsgReceiveService;
    @Autowired
    protected FilterChainFactory filterChainFactory;

    @Override
    public void send(boolean isAgain, String toType, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveList, UserInfo currentUserInfo) {
        List batches = ListUtils.partition(receiveList, (int)this.getBatchSize());
        if (ToTypeEnum.NON_USER.getCode().equals(toType)) {
            batches.forEach(batch -> this.sendBatchNonSystemUser(isAgain, sendTemplate, taskMsgContent, (List<McTaskMsgReceiveEntity>)batch, currentUserInfo));
        } else {
            batches.forEach(batch -> this.sendBatch(isAgain, sendTemplate, taskMsgContent, (List<McTaskMsgReceiveEntity>)batch, currentUserInfo));
        }
    }

    @Override
    public void send(SendMessageContext context) {
        this.executeSend(context);
    }

    protected final void executeSend(SendMessageContext context) {
        this.commonPreCheck(context);
        this.processReceivers(context);
        this.doSend(context);
        this.processSendResult(context);
    }

    private void processSendResult(SendMessageContext context) {
        ArrayList<McTaskMsgReceiveEntity> updateBatch = new ArrayList<McTaskMsgReceiveEntity>();
        List<McTaskMsgReceiveEntity> invalidList = context.getInvalidList();
        List<McTaskMsgReceiveEntity> validList = context.getValidList();
        if (CollectionUtil.isNotEmpty(invalidList)) {
            invalidList.forEach(invalid -> this.updateReceiver((McTaskMsgReceiveEntity)invalid, context.isAgain(), context.getCurrentUser()));
            updateBatch.addAll(invalidList);
        }
        if (CollectionUtil.isNotEmpty(validList)) {
            validList.forEach(valid -> this.updateReceiver((McTaskMsgReceiveEntity)valid, context.isAgain(), context.getCurrentUser()));
            updateBatch.addAll(validList);
        }
        if (CollectionUtil.isNotEmpty(updateBatch)) {
            this.mcTaskMsgReceiveService.updateBatchById(updateBatch);
        }
    }

    private void updateReceiver(McTaskMsgReceiveEntity receiver, boolean isAgain, UserInfo currentUser) {
        if (receiver == null || currentUser == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (isAgain) {
            receiver.setAgainTime(DateUtil.getNowDate());
            receiver.setAgainUserId(currentUser.getUserId());
        } else {
            receiver.setSendTime(DateUtil.getNowDate());
            receiver.setSendUserId(currentUser.getUserId());
        }
        Integer enabledMark = receiver.getEnabledMark();
        String prefix = this.getPrefix(isAgain, enabledMark);
        String userId = StringUtils.defaultString((String)receiver.getDescription(), (String)"");
        receiver.setDescription(String.join((CharSequence)"|", prefix, userId));
        if (isAgain) {
            Integer retryCount = receiver.getAutoAgainNum();
            retryCount = retryCount != null ? retryCount : 0;
            receiver.setAutoAgainNum(EnabledMarkEnum.SUCCESS.getCode().equals(enabledMark) ? 0 : retryCount + 1);
        }
    }

    private String getPrefix(boolean isAgain, Integer enabledMark) {
        if (EnabledMarkEnum.SUCCESS.getCode().equals(enabledMark)) {
            return isAgain ? MsgCenterCode.RESEND_SUCCESS.getDesc() : MsgCenterCode.SEND_SUCCESS.getDesc();
        }
        if (EnabledMarkEnum.FAIL.getCode().equals(enabledMark)) {
            return isAgain ? MsgCenterCode.RESEND_FAILURE.getDesc() : MsgCenterCode.SEND_FAILURE.getDesc();
        }
        return "";
    }

    protected abstract void doSend(SendMessageContext var1) throws SendMessageException;

    private void commonPreCheck(SendMessageContext context) {
        if (ObjectUtil.isEmpty((Object)context.getTaskMsgContent())) {
            throw new SendMessageException(2, "\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
        }
        this.validateParameters(context);
    }

    protected abstract void validateParameters(SendMessageContext var1);

    public void validateTemplate(SendMessageContext context) {
        McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo(context.getSendTemplate().getTemplateId());
        if (ObjectUtil.isNull((Object)templateInfo)) {
            throw new SendMessageException(2, "\u6d88\u606f\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        context.setTemplateInfo(templateInfo);
    }

    public void validateAccount(SendMessageContext context) {
        McMsgAccountEntity msgAccount = this.mcMsgAccountService.getInfo(context.getSendTemplate().getAccountConfigId());
        if (ObjectUtil.isNull((Object)msgAccount)) {
            throw new SendMessageException(2, "\u5e94\u7528\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        context.setMsgAccount(msgAccount);
    }

    public void processReceivers(SendMessageContext context) {
        FilterChain chain;
        String messageType = context.getSendTemplate().getMessageType();
        String toType = context.getToType();
        if (ToTypeEnum.NON_USER.getCode().equals(toType)) {
            chain = this.filterChainFactory.createChain(ChainChannelType.NON_SYS_USER);
        } else {
            ChannelTypeEnum typeEnum = ChannelTypeEnum.getByCode(messageType);
            switch (typeEnum) {
                case SYS_MSG: {
                    chain = this.filterChainFactory.createChain(ChainChannelType.SYS_MSG);
                    break;
                }
                case SMS_MSG: {
                    chain = this.filterChainFactory.createChain(ChainChannelType.SMS);
                    break;
                }
                case DING_MSG: {
                    chain = this.filterChainFactory.createChain(ChainChannelType.DING);
                    break;
                }
                case QY_MSG: 
                case WX_MINIAPP: 
                case WX_MP: {
                    chain = this.filterChainFactory.createChain(ChainChannelType.WECHAT);
                    break;
                }
                case WEBHOOK: {
                    chain = this.filterChainFactory.createChain(ChainChannelType.WEBHOOK);
                    break;
                }
                default: {
                    chain = this.filterChainFactory.createChain(ChainChannelType.DEFAULT);
                }
            }
        }
        chain.process(context);
    }

    protected abstract void sendBatch(boolean var1, McMsgSendTemplateModel var2, McTaskMsgContentEntity var3, List<McTaskMsgReceiveEntity> var4, UserInfo var5);

    protected abstract void sendBatchNonSystemUser(boolean var1, McMsgSendTemplateModel var2, McTaskMsgContentEntity var3, List<McTaskMsgReceiveEntity> var4, UserInfo var5);

    protected abstract int getBatchSize();

    public abstract ChannelTypeEnum getChannelType();
}

