/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.PinYinUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.system.external.service.SynPushToThirdQyService;
import com.bringspring.system.message.service.SynThirdDingTalkService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.mapper.OrganizeMapper;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.model.organize.OrganizeListVO;
import com.bringspring.system.permission.model.organize.OrganizePagination;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class OrganizeServiceImpl
extends ServiceImpl<OrganizeMapper, OrganizeEntity>
implements OrganizeService {
    @Autowired
    private PositionService positionService;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private SynPushToThirdQyService synPushToThirdQyService;
    @Autowired
    private SynThirdDingTalkService synThirdDingTalkService;
    @Autowired
    private Executor threadPoolExecutor;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private OrganizeMapper organizeMapper;
    @Autowired
    private OrganizeService organizeService;

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getListAll(List<String> idAll, String keyWord) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)keyWord)) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(OrganizeEntity::getFullName, (Object)keyWord)).or()).like(PermissionEntityBase::getEnCode, (Object)keyWord);
            });
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(PermissionEntityBase::getLastModifyTime);
        }
        if (idAll.size() > 0) {
            queryWrapper.lambda().in(OrganizeEntity::getId, idAll);
        }
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getAllCompanyList(String keyWord) {
        List<OrganizeEntity> data = this.getList(keyWord);
        List<OrganizeEntity> list = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(data, data), OrganizeEntity.class);
        list = list.stream().filter(t -> "company".equals(t.getCategory())).collect(Collectors.toList());
        return list;
    }

    @Override
    public List<OrganizeEntity> getOrganizeByDataPermission(OrganizePagination organizePagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, organizePagination.getMenuId(), "base_organize"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                return new ArrayList<OrganizeEntity>();
            }
            queryWrapper = (QueryWrapper)companyAuth;
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OrganizeEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode())).select(new SFunction[]{OrganizeEntity::getId, OrganizeEntity::getParentId, OrganizeEntity::getFullName, OrganizeEntity::getShortName, PermissionEntityBase::getEnCode});
        if (StringUtils.isNotEmpty((String)organizePagination.getType())) {
            queryWrapper.lambda().eq(OrganizeEntity::getCategory, (Object)organizePagination.getType());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OrganizeEntity> getAllCompanyDataPermission(OrganizePagination organizePagination) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!userInfo.getIsAdministrator().booleanValue() && Objects.nonNull(organizePagination.getMenuId()) && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, organizePagination.getMenuId(), "base_organize"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                return new ArrayList<OrganizeEntity>();
            }
            queryWrapper = (QueryWrapper)companyAuth;
        }
        if (StringUtil.isNotEmpty((String)organizePagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(OrganizeEntity::getFullName, (Object)organizePagination.getKeyword())).or()).like(OrganizeEntity::getFullName, (Object)organizePagination.getKeyword().toLowerCase());
            });
        }
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.lambda().eq(OrganizeEntity::getCategory, (Object)"company");
        queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode);
        List list = this.list((Wrapper)queryWrapper);
        HashSet<OrganizeEntity> entityList = new HashSet<OrganizeEntity>(16);
        if (StringUtil.isNotEmpty((String)organizePagination.getKeyword())) {
            this.getParentOrganize(list, entityList);
            list.clear();
            list.addAll(entityList);
        }
        return list;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getCompanyList(String modelId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, modelId, "base_organize"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                queryWrapper.lambda().eq(OrganizeEntity::getId, (Object)this.userProvider.get().getOrganizeId());
            } else {
                queryWrapper = (QueryWrapper)companyAuth;
            }
        }
        queryWrapper.lambda().select(new SFunction[]{OrganizeEntity::getId, OrganizeEntity::getFullName, PermissionEntityBase::getEnCode});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(OrganizeEntity::getCategory, (Object)"company")).orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public OrganizeEntity getDirectlyUnderCompanyById(String id) {
        OrganizeEntity info = this.getInfo(id);
        if (StringUtils.isNull((Object)info) || StringUtils.isEmpty((String)info.getOrganizeIdTree())) {
            this.log.error("\u83b7\u53d6\u7ec4\u7ec7\u6811\u51fa\u9519: id=" + id);
            this.log.error(info == null ? String.valueOf(info) : info.toString());
            return null;
        }
        String[] split = info.getOrganizeIdTree().split(",");
        List<String> list = Arrays.asList(split);
        List<OrganizeEntity> orgEntityList = this.getOrgEntityList(list, false);
        Optional<OrganizeEntity> max = orgEntityList.stream().filter(t -> "company".equals(t.getCategory())).max((e1, e2) -> e1.getOrganizeIdTree().compareTo(e2.getOrganizeIdTree()));
        OrganizeEntity directlyOrg = new OrganizeEntity();
        if (!ObjectUtil.isEmpty(max)) {
            directlyOrg = orgEntityList.stream().filter(t -> "company".equals(t.getCategory())).max((e1, e2) -> e1.getOrganizeIdTree().compareTo(e2.getOrganizeIdTree())).get();
        }
        return directlyOrg;
    }

    @Override
    public List<OrganizeEntity> getCompanyById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getOrganizeId, (Object)id);
        queryWrapper.lambda().eq(OrganizeEntity::getCategory, (Object)"department");
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getParentIdList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getParentId, (Object)id);
        queryWrapper.lambda().eq(OrganizeEntity::getCategory, (Object)"department");
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getParentIdListAsc(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getParentId, (Object)id);
        queryWrapper.lambda().eq(OrganizeEntity::getCategory, (Object)"department");
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(PermissionEntityBase::getEnCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getListAscByManagerId(String managerId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getManagerId, (Object)managerId);
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(PermissionEntityBase::getEnCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getListById(Boolean enable) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (enable.booleanValue()) {
            queryWrapper.lambda().eq(OrganizeEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public OrganizeEntity getIdListByFullName(String fullName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getFullName, (Object)fullName);
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.lambda().select(new SFunction[]{OrganizeEntity::getId});
        return (OrganizeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<OrganizeEntity> getList(String keyword) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)keyword)) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(OrganizeEntity::getFullName, (Object)keyword)).or()).like(OrganizeEntity::getFullName, (Object)keyword.toLowerCase());
            });
        }
        queryWrapper.lambda().eq(OrganizeEntity::getCategory, (Object)"company");
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        List list = this.list((Wrapper)queryWrapper);
        HashSet<OrganizeEntity> entityList = new HashSet<OrganizeEntity>(16);
        if (StringUtil.isNotEmpty((String)keyword)) {
            this.getParentOrganize(list, entityList);
            list.clear();
            list.addAll(entityList);
        }
        return list;
    }

    private void getParentOrganize(List<OrganizeEntity> list, Set<OrganizeEntity> entityList) {
        ArrayList<OrganizeEntity> list1 = new ArrayList<OrganizeEntity>(16);
        for (OrganizeEntity entity : list) {
            entityList.add(entity);
            OrganizeEntity info = this.getInfo(entity.getParentId());
            if (!Objects.nonNull(info)) continue;
            list1.add(info);
            if (StringUtil.isNotEmpty((String)info.getParentId()) && !"-1".equals(info.getParentId())) {
                this.getParentOrganize(list1, entityList);
                continue;
            }
            if (!StringUtil.isNotEmpty((String)info.getParentId()) || !"-1".equals(info.getParentId())) continue;
            entityList.add(info);
        }
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getOrgEntityList(List<String> idList, Boolean enable) {
        if (idList.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            if (enable.booleanValue()) {
                queryWrapper.lambda().eq(OrganizeEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
            }
            queryWrapper.lambda().in(OrganizeEntity::getId, idList);
            return this.list((Wrapper)queryWrapper);
        }
        return new ArrayList<OrganizeEntity>();
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getOrgEntityList(Set<String> idList) {
        if (idList.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().select(new SFunction[]{OrganizeEntity::getId, OrganizeEntity::getFullName}).in(OrganizeEntity::getId, idList);
            List list = this.list((Wrapper)queryWrapper);
            return list;
        }
        return new ArrayList<OrganizeEntity>();
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getOrgListCodeNull() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.isNull(PermissionEntityBase::getEnCode)).or()).eq(PermissionEntityBase::getEnCode, (Object)"");
        });
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getOrgRedisList() {
        if (this.cacheUtil.exists("foreverCacheSpace", this.cacheKeyUtil.getOrganizeList())) {
            Object organizeList = this.cacheUtil.query("foreverCacheSpace", this.cacheKeyUtil.getOrganizeList());
            if (organizeList instanceof String) {
                return JsonUtil.getJsonToList((String)organizeList.toString(), OrganizeEntity.class);
            }
            return (List)organizeList;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        List list = this.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            this.cacheUtil.insert("foreverCacheSpace", this.cacheKeyUtil.getOrganizeList(), (Object)JsonUtil.getObjectToString((Object)list), 300L);
        }
        return list;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public OrganizeEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getId, (Object)id);
        return (OrganizeEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<OrganizeEntity> getOrganizeListDataPermission(String menuId) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!userInfo.getIsAdministrator().booleanValue() && Objects.nonNull(menuId) && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "base_organize"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                return new ArrayList<OrganizeEntity>();
            }
            queryWrapper = (QueryWrapper)companyAuth;
        }
        queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode);
        queryWrapper.lambda().eq(OrganizeEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        List list = this.list((Wrapper)queryWrapper);
        if (!userInfo.getIsAdministrator().booleanValue() && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            for (int i = 0; i < list.size(); ++i) {
                if (((OrganizeEntity)list.get(i)).getParentId().equals("-1") || !Objects.nonNull(list.get(i))) continue;
                QueryWrapper queryWrapperOne = new QueryWrapper();
                queryWrapperOne.lambda().eq(OrganizeEntity::getId, (Object)((OrganizeEntity)list.get(i)).getParentId());
                OrganizeEntity organize = (OrganizeEntity)this.organizeMapper.selectOne((Wrapper)queryWrapperOne);
                list.add(organize);
            }
            HashSet entityList = new HashSet(list);
            list.clear();
            list.addAll(entityList);
        }
        return list;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getListDepartmentDataPermission(String id, String menuId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object companyAuth = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "base_organize"));
            if (ObjectUtil.isEmpty((Object)companyAuth)) {
                return new ArrayList<OrganizeEntity>();
            }
            queryWrapper = (QueryWrapper)companyAuth;
        }
        queryWrapper.lambda().eq(OrganizeEntity::getCategory, (Object)"department");
        queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode);
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        List list = this.list((Wrapper)queryWrapper);
        if (!this.userProvider.get().getIsAdministrator().booleanValue()) {
            for (int i = 0; i < list.size(); ++i) {
                if (((OrganizeEntity)list.get(i)).getParentId().equals("-1") || !Objects.nonNull(list.get(i))) continue;
                QueryWrapper queryWrapperOne = new QueryWrapper();
                queryWrapperOne.lambda().eq(OrganizeEntity::getId, (Object)((OrganizeEntity)list.get(i)).getParentId());
                OrganizeEntity organize = (OrganizeEntity)this.organizeMapper.selectOne((Wrapper)queryWrapperOne);
                list.add(organize);
            }
            HashSet entityList = new HashSet(list);
            list.clear();
            list.addAll(entityList);
        }
        if (!StringUtils.isEmpty((String)id) && "1".equals(id)) {
            return list;
        }
        ArrayList<OrganizeEntity> newOrganize = new ArrayList<OrganizeEntity>();
        for (OrganizeEntity organizeEntity : list) {
            if (!organizeEntity.getParentId().equals(id)) continue;
            newOrganize.add(organizeEntity);
        }
        return newOrganize;
    }

    @Override
    public List<OrganizeEntity> getListAllJurisdiction(List<String> idAll, Pagination pagination) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(OrganizeEntity::getFullName, (Object)pagination.getKeyword())).or()).like(PermissionEntityBase::getEnCode, (Object)pagination.getKeyword());
            });
        }
        queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode);
        if (flag) {
            queryWrapper.lambda().orderByDesc(PermissionEntityBase::getLastModifyTime);
        }
        if (idAll.size() > 0) {
            queryWrapper.lambda().in(OrganizeEntity::getId, idAll);
        }
        if (idAll.size() == 0) {
            queryWrapper.lambda().eq(OrganizeEntity::getFullName, (Object)"");
        }
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public OrganizeEntity getCompanyListById(String id) {
        OrganizeEntity info = this.getInfo(id);
        String[] split = info.getOrganizeIdTree().split(",");
        List<String> list = Arrays.asList(split);
        List<OrganizeEntity> orgEntityList = this.getOrgEntityList(list, false);
        OrganizeEntity directlyOrg = orgEntityList.stream().filter(t -> "company".equals(t.getCategory())).max((e1, e2) -> e1.getOrganizeIdTree().compareTo(e2.getOrganizeIdTree())).get();
        return directlyOrg;
    }

    @Override
    public String getOrganizeIdTreeALL(OrganizeEntity entity) {
        ArrayList<String> list = new ArrayList<String>();
        this.getOrganizeIdTree(entity.getParentId(), list);
        Collections.reverse(list);
        StringBuffer organizeIdTree = new StringBuffer();
        for (String organizeParentId : list) {
            organizeIdTree.append("," + organizeParentId);
        }
        organizeIdTree.append("," + entity.getId());
        String organizeParentIdTree = organizeIdTree.toString();
        if (StringUtils.isNotEmpty((String)organizeParentIdTree)) {
            organizeParentIdTree = organizeParentIdTree.replaceFirst(",", "");
        }
        return organizeParentIdTree;
    }

    @Override
    public String getOrganizeIds(OrganizeEntity entity) {
        ArrayList<String> list = new ArrayList<String>();
        this.getCompanyId(entity.getParentId(), list);
        Collections.reverse(list);
        StringBuffer organizeIdTree = new StringBuffer();
        String organizeParentIdTree = organizeIdTree.toString();
        if (StringUtils.isNotEmpty(list)) {
            organizeParentIdTree = (String)list.get(list.size() - 1);
        }
        return organizeParentIdTree;
    }

    @Override
    public void getOrganizeId(String organizeId, List<OrganizeEntity> organizeList) {
        OrganizeEntity entity = this.getInfo(organizeId);
        if (entity != null) {
            organizeList.add(entity);
            if (StringUtils.isNotEmpty((String)entity.getParentId())) {
                this.getOrganizeId(entity.getParentId(), organizeList);
            }
        }
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public OrganizeEntity getByFullName(String fullName) {
        OrganizeEntity organizeEntity = new OrganizeEntity();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getFullName, (Object)fullName);
        queryWrapper.lambda().select(new SFunction[]{OrganizeEntity::getId});
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        List list = this.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            organizeEntity = (OrganizeEntity)list.get(0);
        }
        return organizeEntity;
    }

    @Override
    public boolean isExistByFullName(OrganizeEntity entity, boolean isCheck, boolean isFilter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getFullName, (Object)entity.getFullName());
        if (!isCheck) {
            List entityList;
            if (isFilter) {
                queryWrapper.lambda().ne(OrganizeEntity::getId, (Object)entity.getId());
            }
            if ((entityList = this.list((Wrapper)queryWrapper)).size() > 0) {
                for (OrganizeEntity organizeEntity : entityList) {
                    if (organizeEntity == null || !organizeEntity.getParentId().equals(entity.getParentId()) || !organizeEntity.getCategory().equals(entity.getCategory())) continue;
                    return true;
                }
            }
            return false;
        }
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void getOrganizeIdTree(String organizeId, List<String> organizeParentIdList) {
        OrganizeEntity entity = this.getInfo(organizeId);
        if (entity != null) {
            organizeParentIdList.add(entity.getId());
            if (StringUtils.isNotEmpty((String)entity.getParentId())) {
                this.getOrganizeIdTree(entity.getParentId(), organizeParentIdList);
            }
        }
    }

    @Override
    public void getCompanyId(String organizeId, List<String> organizeParentIdList) {
        OrganizeEntity entity = this.getInfo(organizeId);
        if (entity != null) {
            if ("company".equals(entity.getCategory())) {
                organizeParentIdList.add(entity.getId());
            }
            if (StringUtils.isNotEmpty((String)entity.getParentId())) {
                this.getCompanyId(entity.getParentId(), organizeParentIdList);
            }
        }
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(OrganizeEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isEnabledMark(String id) {
        List<OrganizeEntity> parentIdList = this.organizeService.getParentIdList(id);
        List<UserEntity> list = this.userService.getList();
        List userOrganizeIds = list.stream().filter(s -> StringUtils.isNotEmpty((String)s.getOrganizeId())).map(UserEntity::getOrganizeId).collect(Collectors.toList());
        if (!parentIdList.isEmpty()) {
            List organizeIds = parentIdList.stream().map(OrganizeEntity::getId).collect(Collectors.toList());
            organizeIds.add(id);
            List intersection = userOrganizeIds.stream().filter(organizeIds::contains).collect(Collectors.toList());
            if (!intersection.isEmpty()) {
                return true;
            }
        } else if (userOrganizeIds.contains(id)) {
            return true;
        }
        return false;
    }

    @Override
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public void create(OrganizeEntity entity) throws PermissionException {
        if (this.isExistByFullName(entity, false, false)) {
            throw new PermissionException("\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        if (ObjectUtil.isEmpty((Object)entity.getEnCode())) {
            entity.setEnCode(PinYinUtil.getFirstSpell((String)entity.getFullName()));
        }
        UserInfo operatorUser = this.userProvider.get();
        if (StringUtils.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtil.uuId());
        }
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        entity.setDeleteUserId(operatorUser.getUserId());
        entity.setDeleteTime(new Date());
        String organizeIdTree = this.getOrganizeIdTreeALL(entity);
        entity.setOrganizeIdTree(organizeIdTree);
        entity.setOrganizeId(this.getOrganizeIds(entity));
        this.save(entity);
    }

    @Override
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public void createDepartment(OrganizeEntity entity) throws PermissionException {
        if (this.isExistByFullName(entity, false, false)) {
            throw new PermissionException("\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        entity.setCategory("department");
        if (ObjectUtil.isEmpty((Object)entity.getEnCode())) {
            entity.setEnCode(PinYinUtil.getFirstSpell((String)entity.getFullName()));
        }
        UserInfo operatorUser = this.userProvider.get();
        if (StringUtils.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtil.uuId());
        }
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        entity.setDeleteUserId(operatorUser.getUserId());
        entity.setDeleteTime(new Date());
        String organizeIdTree = this.getOrganizeIdTreeALL(entity);
        entity.setOrganizeIdTree(organizeIdTree);
        entity.setOrganizeId(this.getOrganizeIds(entity));
        this.save(entity);
        this.threadPoolExecutor.execute(() -> {
            try {
                this.synPushToThirdQyService.createDepartmentSysToQy(operatorUser, false, entity, "");
            }
            catch (Exception e) {
                this.log.error("\u521b\u5efa\u90e8\u95e8\u540e\u540c\u6b65\u7b2c\u4e09\u65b9\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
            }
        });
    }

    @Override
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public void batchSaveOrUpdateBatch(List<OrganizeEntity> entity) {
        this.saveOrUpdateBatch(entity);
    }

    @Override
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public boolean update(String id, OrganizeEntity entity) {
        entity.setId(id);
        String organizeIdTree = this.getOrganizeIdTreeALL(entity);
        entity.setOrganizeIdTree(organizeIdTree);
        OrganizeEntity info = this.getInfo(id);
        boolean updateById = this.updateById(entity);
        if (info != null && !entity.getParentId().equals(info.getParentId())) {
            this.update(entity, info.getCategory());
        }
        if (this.synPushToThirdQyService.triggeringCondition(info, entity)) {
            UserInfo operatorUser = this.userProvider.get();
            this.threadPoolExecutor.execute(() -> {
                try {
                    this.synPushToThirdQyService.updateDepartmentSysToQy(operatorUser, false, entity, "");
                }
                catch (Exception e) {
                    this.log.error("\u4fee\u6539\u7ec4\u7ec7\u540e\u540c\u6b65\u5931\u8d25\u5230\u4f01\u4e1a\u5fae\u4fe1\u6216\u9489\u9489\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        if (this.synPushToThirdQyService.triggeringConditionForUser(info, entity)) {
            UserEntity oldManager = this.userService.getInfo(info.getManagerId());
            UserEntity newManager = this.userService.getInfo(entity.getManagerId());
            UserInfo operatorUser = this.userProvider.get();
            if (ObjectUtil.isNotEmpty((Object)oldManager)) {
                this.threadPoolExecutor.execute(() -> {
                    try {
                        this.synPushToThirdQyService.updateUserSysToQy(operatorUser, false, oldManager, null);
                    }
                    catch (Exception e) {
                        this.log.error("\u4fee\u6539\u90e8\u95e8\u4e4b\u540e\u540c\u6b65\u7528\u6237\u5230\u4f01\u4e1a\u5fae\u4fe1\u6216\u9489\u9489\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                });
            }
            if (ObjectUtil.isNotEmpty((Object)newManager)) {
                this.threadPoolExecutor.execute(() -> {
                    try {
                        this.synPushToThirdQyService.updateUserSysToQy(operatorUser, false, newManager, null);
                    }
                    catch (Exception e) {
                        this.log.error("\u4fee\u6539\u90e8\u95e8\u4e4b\u540e\u540c\u6b65\u7528\u6237\u5230\u4f01\u4e1a\u5fae\u4fe1\u6216\u9489\u9489\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                });
            }
        }
        return updateById;
    }

    @Override
    @DSTransactional
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public Boolean update(OrganizeEntity entity) {
        return this.updateById(entity);
    }

    @Override
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public boolean updateDepartment(String id, OrganizeEntity entity) {
        entity.setId(id);
        String organizeIdTree = this.getOrganizeIdTreeALL(entity);
        entity.setOrganizeIdTree(organizeIdTree);
        OrganizeEntity info = this.getInfo(id);
        boolean updateById = this.updateById(entity);
        if (info != null && !entity.getParentId().equals(info.getParentId())) {
            this.update(entity, info.getCategory());
        }
        if (this.synPushToThirdQyService.triggeringCondition(info, entity)) {
            UserInfo operatorUser = this.userProvider.get();
            this.threadPoolExecutor.execute(() -> {
                try {
                    this.synPushToThirdQyService.updateDepartmentSysToQy(operatorUser, false, entity, "");
                }
                catch (Exception e) {
                    this.log.error("\u4fee\u6539\u90e8\u95e8\u540e\u540c\u6b65\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        if (this.synPushToThirdQyService.triggeringConditionForUser(info, entity)) {
            UserEntity oldManager = this.userService.getInfo(info.getManagerId());
            UserEntity newManager = this.userService.getInfo(entity.getManagerId());
            UserInfo operatorUser = this.userProvider.get();
            if (ObjectUtil.isNotEmpty((Object)oldManager)) {
                this.threadPoolExecutor.execute(() -> {
                    try {
                        this.synPushToThirdQyService.updateUserSysToQy(operatorUser, false, oldManager, null);
                    }
                    catch (Exception e) {
                        this.log.error("\u4fee\u6539\u90e8\u95e8\u4e4b\u540e\u540c\u6b65\u7528\u6237\u5230\u4f01\u4e1a\u5fae\u4fe1\u6216\u9489\u9489\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                });
            }
            if (ObjectUtil.isNotEmpty((Object)newManager)) {
                this.threadPoolExecutor.execute(() -> {
                    try {
                        this.synPushToThirdQyService.updateUserSysToQy(operatorUser, false, newManager, null);
                    }
                    catch (Exception e) {
                        this.log.error("\u4fee\u6539\u90e8\u95e8\u4e4b\u540e\u540c\u6b65\u7528\u6237\u5230\u4f01\u4e1a\u5fae\u4fe1\u6216\u9489\u9489\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                    }
                });
            }
        }
        return updateById;
    }

    @Override
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public void update(OrganizeEntity entity, String category) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getParentId, (Object)entity.getId());
        if ("company".equals(category)) {
            queryWrapper.lambda().eq(OrganizeEntity::getCategory, (Object)"company");
        } else {
            queryWrapper.lambda().eq(OrganizeEntity::getCategory, (Object)"department");
        }
        List list = this.list((Wrapper)queryWrapper);
        for (OrganizeEntity organizeEntity : list) {
            String organizeIdTree = this.getOrganizeIdTreeALL(entity);
            organizeEntity.setOrganizeIdTree(organizeIdTree);
            this.updateById(organizeEntity);
        }
    }

    @Override
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public ActionResult<String> delete(String orgId) {
        return this.delete(orgId, null);
    }

    @Override
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public ActionResult<String> delete(String orgId, String actionType) {
        String flag = this.allowDelete(orgId);
        if (flag == null) {
            OrganizeEntity organizeEntity = this.getInfo(orgId);
            if (organizeEntity != null) {
                this.removeById((Serializable)((Object)orgId));
                if (StringUtils.isEmpty((String)actionType) || actionType.equals("sys_delete")) {
                    UserInfo operatorUser = this.userProvider.get();
                    this.threadPoolExecutor.execute(() -> {
                        try {
                            this.synPushToThirdQyService.deleteDepartmentSysToQy(operatorUser, false, orgId, "");
                        }
                        catch (Exception e) {
                            this.log.error("\u5220\u9664\u90e8\u95e8\u540e\u540c\u6b65\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                        }
                    });
                }
                return ActionResult.success((String)MsgCode.SU003.get());
            }
            return ActionResult.fail((String)MsgCode.FA003.get());
        }
        return ActionResult.fail((String)("\u6b64\u8bb0\u5f55\u4e0e\"" + flag + "\"\u5173\u8054\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u88ab\u5220\u9664"));
    }

    @Override
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public boolean deleteDepartmentByLogical(String orgId) throws PermissionException {
        String flag = this.allowDelete(orgId);
        if (flag == null) {
            UserInfo operatorUser = this.userProvider.get();
            OrganizeEntity entity = this.getInfo(orgId);
            entity.setDeleteMark(DeleteMarkEnum.DELETED.getCode());
            entity.setDeleteTime(new Date());
            entity.setDeleteUserId(operatorUser.getUserId());
            boolean updateFlag = this.updateById(entity);
            this.threadPoolExecutor.execute(() -> {
                try {
                    this.synPushToThirdQyService.deleteDepartmentSysToQy(operatorUser, false, orgId, "");
                }
                catch (Exception e) {
                    this.log.error("\u5220\u9664\u90e8\u95e8\u540e\u540c\u6b65\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
            return updateFlag;
        }
        throw new PermissionException("\u6b64\u8bb0\u5f55\u4e0e\"" + flag + "\"\u5173\u8054\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u88ab\u5220\u9664");
    }

    @Override
    @DSTransactional
    public boolean first(String id) {
        boolean isOk = false;
        OrganizeEntity upEntity = (OrganizeEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = upEntity.getSortCode() == null ? 0L : upEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().lt(PermissionEntityBase::getSortCode, (Object)upSortCode)).eq(OrganizeEntity::getParentId, (Object)upEntity.getParentId())).orderByAsc(PermissionEntityBase::getSortCode);
        List downEntity = this.list((Wrapper)queryWrapper);
        if (downEntity.size() > 0) {
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(((OrganizeEntity)downEntity.get(0)).getSortCode());
            ((OrganizeEntity)downEntity.get(0)).setSortCode(temp);
            this.updateById(downEntity.get(0));
            this.updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    @DSTransactional
    public boolean next(String id) {
        boolean isOk = false;
        OrganizeEntity downEntity = (OrganizeEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = downEntity.getSortCode() == null ? 0L : downEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().gt(PermissionEntityBase::getSortCode, (Object)upSortCode)).eq(OrganizeEntity::getParentId, (Object)downEntity.getParentId())).orderByAsc(PermissionEntityBase::getSortCode);
        List upEntity = this.list((Wrapper)queryWrapper);
        if (upEntity.size() > 0) {
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(((OrganizeEntity)upEntity.get(0)).getSortCode());
            ((OrganizeEntity)upEntity.get(0)).setSortCode(temp);
            this.updateById(upEntity.get(0));
            this.updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public String allowDelete(String orgId) {
        List<OrganizeEntity> list = this.getListByParentId(orgId);
        if (Objects.nonNull(list) && list.size() > 0) {
            return "\u7ec4\u7ec7";
        }
        List<PositionEntity> list1 = this.positionService.getListByOrganizeId(orgId);
        if (Objects.nonNull(list1) && list1.size() > 0) {
            return "\u5c97\u4f4d";
        }
        if (this.userRelationService.existByObjectId(orgId, "Organize").booleanValue()) {
            return "\u7528\u6237";
        }
        if (this.organizeRelationService.existByObjTypeAndOrgId(orgId, "Role").booleanValue()) {
            return "\u89d2\u8272";
        }
        return null;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getOrganizeName(List<String> id) {
        List<OrganizeEntity> list = new ArrayList<OrganizeEntity>();
        if (id.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(OrganizeEntity::getId, id);
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getOrganizeNameSort(List<String> id) {
        ArrayList<OrganizeEntity> list = new ArrayList<OrganizeEntity>();
        List organizeTree = id.stream().distinct().collect(Collectors.toList());
        for (String orgId : organizeTree) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(OrganizeEntity::getId, (Object)orgId);
            queryWrapper.lambda().select(new SFunction[]{OrganizeEntity::getFullName});
            OrganizeEntity entity = (OrganizeEntity)this.getOne((Wrapper)queryWrapper);
            if (entity == null) continue;
            list.add(entity);
        }
        return list;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<String> getOrganize(String organizeParentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getParentId, (Object)organizeParentId);
        queryWrapper.lambda().select(new SFunction[]{OrganizeEntity::getId});
        List<String> list = this.list((Wrapper)queryWrapper).stream().map(t -> t.getId()).collect(Collectors.toList());
        return list;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<String> getOrganizeByOraParentId(String organizeParentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getParentId, (Object)organizeParentId);
        List list = this.list((Wrapper)queryWrapper);
        return list.stream().map(t -> t.getId()).collect(Collectors.toList());
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<String> getUnderOrganizations(String organizeId) {
        ArrayList<String> totalIds = new ArrayList<String>();
        this.getOrganizations(organizeId, this.getList(), totalIds);
        totalIds.add(organizeId);
        return totalIds;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getListByFullName(String fullName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getFullName, (Object)fullName);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getListByParentId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OrganizeEntity::getParentId, (Object)id);
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    private void getOrganizations(String organizeId, List<OrganizeEntity> allIdList, List<String> totalIds) {
        List organizations = allIdList.stream().filter(org -> org.getParentId().equals(organizeId)).map(organize -> organize.getId()).collect(Collectors.toList());
        if (organizations.size() > 0) {
            totalIds.addAll(organizations);
            for (String id : organizations) {
                this.getOrganizations(id, allIdList, totalIds);
            }
        }
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getAllOrgByUserId(String userId) {
        ArrayList ids = new ArrayList();
        this.userRelationService.getAllOrgRelationByUserId(userId).forEach(r -> ids.add(r.getObjectId()));
        if (ObjectUtil.isEmpty(ids)) {
            return null;
        }
        return this.listByIds(ids);
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public String getFullNameByOrgIdTree(String orgIdTree, String regex) {
        String fullName = "";
        if (StringUtils.isNotEmpty((String)orgIdTree)) {
            String[] split = orgIdTree.split(",");
            StringBuilder orgName = new StringBuilder();
            for (String orgId : split) {
                OrganizeEntity entity = this.getInfo(orgId);
                if (entity == null) continue;
                orgName.append(regex).append(entity.getFullName());
            }
            if (orgName.length() > 0) {
                fullName = orgName.toString().replaceFirst(regex, "");
            }
        }
        return fullName;
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getListLikeOrgIdTree(String orgId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.lambda().like(OrganizeEntity::getOrganizeIdTree, (Object)orgId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeEntity> getListByCompanyIds(List<String> companyIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getCode());
        queryWrapper.lambda().in(OrganizeEntity::getOrganizeId, companyIds);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkCodeUnique(String code, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PermissionEntityBase::getEnCode, (Object)code);
        queryWrapper.last("limit 1");
        OrganizeEntity entity = (OrganizeEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || !StringUtils.isEmpty((String)id) && entity.getId().equals(id);
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result.size()==0")
    public List<OrganizeListVO> getListTree(String parentId) {
        List<OrganizeEntity> listByParentId = this.getListByParentId(parentId);
        if (CollectionUtil.isNotEmpty(listByParentId)) {
            List listVO = JsonUtil.getJsonToList(listByParentId, OrganizeListVO.class);
            this.recursionTree(listVO);
            return listVO;
        }
        return null;
    }

    private void recursionTree(List<OrganizeListVO> returnList) {
        returnList.stream().forEach(item -> {
            List<OrganizeEntity> listChild = this.getListByParentId(item.getId());
            if (ObjectUtil.isEmpty(listChild)) {
                return;
            }
            List listVO = JsonUtil.getJsonToList(listChild, OrganizeListVO.class);
            item.setChildren(listVO);
            this.recursionTree(listVO);
        });
    }

    @Override
    @Cacheable(value={"OrganizeCache"}, keyGenerator="cacheKeyGenerator", unless="#result==null")
    public OrganizeEntity getByEnCode(String enCode) {
        if (StringUtils.isEmpty((String)enCode)) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PermissionEntityBase::getEnCode, (Object)enCode);
        queryWrapper.lambda().eq(OrganizeEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return (OrganizeEntity)list.get(0);
        }
        return null;
    }
}

