package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.model.baseSyncThirdInfo.BaseSyncThirdInfoInfoVO;
import com.bringspring.system.base.model.baseSyncThirdInfo.BaseSyncThirdInfoListVO;
import com.bringspring.system.base.model.baseSyncThirdInfo.BaseSyncThirdInfoPagination;
import com.bringspring.system.base.service.BaseSyncThirdInfoService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.List;

/**
 * 第三方同步
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-08-19
 */
@Slf4j
@RestController
@Api(tags = "第三方同步", value = "SyncThirdInfo")
@RequestMapping("/api/system/base/thirdInfo")
public class BaseSyncThirdInfoController {

    @Autowired
    private BaseDataUtil baseDataUtil;

    @Autowired
    private BaseSyncThirdInfoService baseSyncThirdInfoService;


    /**
     * 列表
     *
     * @param baseSyncThirdInfoPagination
     * @return
     */
    @PostMapping("/getList")
    public ActionResult list(@RequestBody BaseSyncThirdInfoPagination baseSyncThirdInfoPagination) throws IOException {
        List<SynThirdInfoEntity> list = baseSyncThirdInfoService.getList(baseSyncThirdInfoPagination);
        List<BaseSyncThirdInfoListVO> listVO = JsonUtil.getJsonToList(list, BaseSyncThirdInfoListVO.class);
        for (BaseSyncThirdInfoListVO infoVO : listVO) {
            //处理id字段转名称，若无需转或者为空可删除
            if (SynThirdConsts.DATA_TYPE_USER.equals(infoVO.getDataType())) {
                infoVO.setSystemObjectId(baseDataUtil.userSelectValue(infoVO.getSystemObjectId()));
            } else {
                infoVO.setSystemObjectId(baseDataUtil.comSelectValues(infoVO.getSystemObjectId()));
            }
            infoVO.setCreatorUserId(baseDataUtil.userSelectValue(infoVO.getCreatorUserId()));
            infoVO.setLastModifyUserId(baseDataUtil.userSelectValue(infoVO.getLastModifyUserId()));
        }

        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(baseSyncThirdInfoPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * 信息
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public ActionResult<BaseSyncThirdInfoInfoVO> info(@PathVariable("id") String id) {
        SynThirdInfoEntity entity = baseSyncThirdInfoService.getInfo(id);
        BaseSyncThirdInfoInfoVO vo = JsonUtil.getJsonToBean(entity, BaseSyncThirdInfoInfoVO.class);
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setCreatorUserId(baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        vo.setLastModifyUserId(baseDataUtil.userSelectValue(vo.getLastModifyUserId()));

        return ActionResult.success(vo);
    }

    /**
     * 表单信息(详情页)
     *
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public ActionResult<BaseSyncThirdInfoInfoVO> detailInfo(@PathVariable("id") String id) {
        SynThirdInfoEntity entity = baseSyncThirdInfoService.getInfo(id);
        BaseSyncThirdInfoInfoVO vo = JsonUtil.getJsonToBean(entity, BaseSyncThirdInfoInfoVO.class);

        //添加到详情表单对象中
        vo.setCreatorUserId(baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(baseDataUtil.userSelectValue(vo.getLastModifyUserId()));

        return ActionResult.success(vo);
    }

}
