

package com.bringspring.system.base.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.DataInterfaceFormatEntity;
import com.bringspring.system.base.model.datainterfaceformat.BaseDataInterfaceFormatCrForm;
import com.bringspring.system.base.model.datainterfaceformat.BaseDataInterfaceFormatInfoVO;
import com.bringspring.system.base.model.datainterfaceformat.BaseDataInterfaceFormatListVO;
import com.bringspring.system.base.model.datainterfaceformat.BaseDataInterfaceFormatPagination;
import com.bringspring.system.base.model.datainterfaceformat.BaseDataInterfaceFormatUpForm;
import com.bringspring.system.base.service.DataInterfaceFormatService;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.io.IOException;
import java.util.List;

/**
 * 接口数据格式转换样例
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-08-15
 */
@Slf4j
@RestController
@Api(tags = "接口数据格式转换样例", value = "daap")
@RequestMapping("/api/system/BaseDataInterfaceFormat")
public class DataInterfaceFormatController {
    @Autowired
    private UserProvider userProvider;

    @Autowired
    private DataInterfaceFormatService baseDataInterfaceFormatService;


    /**
     * 列表
     *
     * @param baseDataInterfaceFormatPagination
     * @return
     */
    @PostMapping("/getList")
    public ActionResult list(@RequestBody BaseDataInterfaceFormatPagination baseDataInterfaceFormatPagination) throws IOException {
        List<DataInterfaceFormatEntity> list = baseDataInterfaceFormatService.getList(baseDataInterfaceFormatPagination);
        //处理id字段转名称，若无需转或者为空可删除

        List<BaseDataInterfaceFormatListVO> listVO = JsonUtil.getJsonToList(list, BaseDataInterfaceFormatListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(baseDataInterfaceFormatPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * 创建
     *
     * @param baseDataInterfaceFormatCrForm
     * @return
     */
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid BaseDataInterfaceFormatCrForm baseDataInterfaceFormatCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = userProvider.get();
        DataInterfaceFormatEntity entity = JsonUtil.getJsonToBean(baseDataInterfaceFormatCrForm, DataInterfaceFormatEntity.class);
        entity.setId(mainId);
        baseDataInterfaceFormatService.save(entity);


        return ActionResult.success("创建成功");
    }


    /**
     * 信息
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public ActionResult<BaseDataInterfaceFormatInfoVO> info(@PathVariable("id") String id) {
        DataInterfaceFormatEntity entity = baseDataInterfaceFormatService.getInfo(id);
        BaseDataInterfaceFormatInfoVO vo = JsonUtil.getJsonToBean(entity, BaseDataInterfaceFormatInfoVO.class);

        //子表
        //副表
        return ActionResult.success(vo);
    }

    /**
     * 表单信息(详情页)
     *
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public ActionResult<BaseDataInterfaceFormatInfoVO> detailInfo(@PathVariable("id") String id) {
        DataInterfaceFormatEntity entity = baseDataInterfaceFormatService.getInfo(id);
        BaseDataInterfaceFormatInfoVO vo = JsonUtil.getJsonToBean(entity, BaseDataInterfaceFormatInfoVO.class);

        //子表数据转换

        //附表数据转换

//添加到详情表单对象中

        return ActionResult.success(vo);
    }


    /**
     * 更新
     *
     * @param id
     * @return
     */
    @PutMapping("/{id}")
    @DSTransactional
    public ActionResult update(@PathVariable("id") String id, @RequestBody @Valid BaseDataInterfaceFormatUpForm baseDataInterfaceFormatUpForm) throws DataException {
        UserInfo userInfo = userProvider.get();
        DataInterfaceFormatEntity entity = baseDataInterfaceFormatService.getInfo(id);
        if (entity != null) {
            DataInterfaceFormatEntity subentity = JsonUtil.getJsonToBean(baseDataInterfaceFormatUpForm, DataInterfaceFormatEntity.class);
            baseDataInterfaceFormatService.update(id, subentity);
            return ActionResult.success("更新成功");
        } else {
            return ActionResult.fail("更新失败，数据不存在");
        }
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    @DSTransactional
    public ActionResult delete(@PathVariable("id") String id) {
        DataInterfaceFormatEntity entity = baseDataInterfaceFormatService.getInfo(id);
        if (entity != null) {
            baseDataInterfaceFormatService.delete(entity);

        }
        return ActionResult.success("删除成功");
    }


}
