package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.DbBackupEntity;
import com.bringspring.system.base.model.dbbackup.DbBackupListVO;
import com.bringspring.system.base.service.DbBackupService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 数据备份
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Api(tags = "数据备份", value = "DataBackup")
@RestController
@RequestMapping("/api/system/DataBackup")
public class DbBackupController {

    @Autowired
    private DbBackupService dbBackupService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;

    /**
     * 列表
     *
     * @param pagination 分页参数
     * @return ignore
     */
    @ApiOperation("获取数据备份列表(带分页)")
    @GetMapping
    public ActionResult<PageListVO<DbBackupListVO>> list(Pagination pagination) {
        UserInfo userInfo = userProvider.get();
        List<DbBackupEntity> list = dbBackupService.getList(pagination);

        PaginationVO paginationVO = JsonUtil.getJsonToBean(pagination, PaginationVO.class);
        List<DbBackupListVO> listVos = JsonUtil.getJsonToList(list, DbBackupListVO.class);
        for (DbBackupListVO dbList : listVos) {
            String filePath = configValueUtil.getDataBackupFilePath() + dbList.getFileName();
            if (FileUtil.fileIsFile(filePath)) {
                dbList.setFileUrl(UploaderUtil.uploaderFile(userInfo.getId() + "#" + dbList.getFileName() + "#dataBackup"));
            }
        }
        return ActionResult.page(listVos, paginationVO);
    }

    /**
     * 删除
     *
     * @param id 主键
     * @return ignore
     * @throws DataException ignore
     */
    @ApiOperation("删除数据备份")
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) throws DataException {
        DbBackupEntity entity = dbBackupService.getInfo(id);
        if (entity != null) {
            dbBackupService.delete(entity);
            return ActionResult.success(MsgCode.SU003.get());
        }
        return ActionResult.fail(MsgCode.FA003.get());
    }
}
