package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.system.base.model.dbsync.DbSyncForm;
import com.bringspring.system.base.service.DbSyncService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 数据同步
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Api(tags = "数据同步", value = "DataSync")
@RestController
@RequestMapping("/api/system/DataSync")
public class DbSyncController {

    @Autowired
    private DbSyncService dbSyncService;

    /**
     * 执行数据同步
     *
     * @param dbSyncForm 数据同步参数
     * @return ignore
     * @throws Exception ignore
     */
    @PostMapping
    @ApiOperation("数据同步校验")
    public ActionResult<Object> checkExecute(@RequestBody DbSyncForm dbSyncForm) throws Exception {
        int status;
        try {
            status = dbSyncService
                    .checkExecute(dbSyncForm.getDbConnectionFrom(), dbSyncForm.getDbConnectionTo(), dbSyncForm.getDbTable());
        } catch (DataException e) {
            return ActionResult.fail("被同步数据库连接失败。" + e.getMessage());
        }
        if (status == -1) {
            return ActionResult.fail("请检查，同一数据库下无法同步数据");
        }
        return ActionResult.success(status);
    }

    /**
     * 执行数据同步
     *
     * @param dbSyncForm 数据同步参数
     * @return ignore
     * @throws Exception ignore
     */
    @PostMapping("Actions/Execute")
    @ApiOperation("执行数据同步")
    public ActionResult<String> execute(@RequestBody DbSyncForm dbSyncForm) throws Exception {
        dbSyncService
                .executeImport(dbSyncForm.getDbConnectionFrom(), dbSyncForm.getDbConnectionTo(), dbSyncForm.getDbTable());
        //返回结果信息
        return ActionResult.success("成功");
    }

    /**
     * 格式化单表
     */
    public void initTable(){

    }


    /**
     * 批量
     */
    public void batchImport(){
        String[] tables = {"a","b","c"};
        


    }


}
