package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.*;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.enums.SearchMethodEnum;
import com.bringspring.system.base.entity.ModuleDataAuthorizeEntity;
import com.bringspring.system.base.entity.ModuleDataAuthorizeSchemeEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.model.module.PropertyJsonModel;
import com.bringspring.system.base.model.moduledataauthorize.DataAuthorizeCrForm;
import com.bringspring.system.base.model.moduledataauthorize.DataAuthorizeInfoVO;
import com.bringspring.system.base.model.moduledataauthorize.DataAuthorizeListVO;
import com.bringspring.system.base.model.moduledataauthorize.DataAuthorizeUpForm;
import com.bringspring.system.base.service.ModuleDataAuthorizeSchemeService;
import com.bringspring.system.base.service.ModuleDataAuthorizeService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.model.authorize.ConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;


/**
 * 数据权限配置
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Api(tags = "数据权限字段管理", value = "ModuleDataAuthorize")
@RestController
@RequestMapping("/api/system/ModuleDataAuthorize")
public class ModuleDataAuthorizeController {

    @Autowired
    private ModuleDataAuthorizeService dataAuthorizeService;
    @Autowired
    private ModuleDataAuthorizeSchemeService dataAuthorizeSchemeService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private AuthorizeService authorizeService;

    /**
     * 获取数据权限配置信息列表
     *
     * @param moduleId 功能主键
     * @return ignore
     */
    @ApiOperation("获取字段列表")
    @GetMapping("/{moduleId}/List")
    public ActionResult<ListVO<DataAuthorizeListVO>> list(@PathVariable("moduleId") String moduleId) {
        List<ModuleDataAuthorizeEntity> data = dataAuthorizeService.getList(moduleId);
        List<DataAuthorizeListVO> list = JsonUtil.getJsonToList(data, DataAuthorizeListVO.class);
        list.stream().forEach(t -> {
            // 处理条件符号
            String conditionSymbol = StringUtils.isNotEmpty(t.getConditionSymbol()) ? t.getConditionSymbol() : "";
            StringJoiner symbolJoiner = new StringJoiner(",");
            String[] symbolSplit = conditionSymbol.split(",");
            for (String id : symbolSplit) {
                SearchMethodEnum itemMethod = SearchMethodEnum.getSearchMethod(id);
                if (itemMethod != null) {
                    symbolJoiner.add(itemMethod.getMessage());
                }
            }
            // 处理条件名称
            t.setConditionText(StringUtils.isNotEmpty(t.getConditionText()) ? t.getConditionText() : "");
            StringJoiner textJoiner = new StringJoiner(",");
            String conditionText = StringUtils.isNotEmpty(t.getConditionText()) ? t.getConditionText() : "";
            String[] textSplit = conditionText.split(",");
            for (String id : textSplit) {
//                AuthorizeConditionEnum itemMethod = AuthorizeConditionEnum.getByMessage(id);
//                if (itemMethod != null) {
//                    textJoiner.add(itemMethod.getMessage());
//                }
                textJoiner.add(authorizeService.getDescByCondition(id));
            }

            t.setConditionSymbolName(symbolJoiner.toString());
            t.setConditionName(textJoiner.toString());

            // 处理字段名称
            if (StringUtils.isNotEmpty(t.getBindTable())) {
                t.setEnCode(StringUtils.isNotEmpty(t.getEnCode()) ?
                        t.getEnCode().replace(t.getBindTable() + ".", "") : "");
            }

        });

        ListVO<DataAuthorizeListVO> vo = new ListVO<>();
        vo.setList(list);
        return ActionResult.success(vo);
    }

    /**
     * 菜单数据权限
     *
     * @param moduleId 功能主键
     * @return ignore
     */
    @ApiOperation("菜单数据权限")
    @GetMapping("/{moduleId}/FieldList")
    public ActionResult fieldList(@PathVariable("moduleId") String moduleId) {
        List<Map<String, String>> list = new ArrayList<>();
        // 得到菜单id
        ModuleEntity entity = moduleService.getInfo(moduleId);
        PropertyJsonModel model = JsonUtil.getJsonToBean(entity.getPropertyJson(), PropertyJsonModel.class);
        if (model == null) {
            model = new PropertyJsonModel();
        }
        // 得到bean
        Object bean = SpringContext.getBean("visualdevServiceImpl");
        Object method = ReflectionUtil.invokeMethod(bean, "getInfo", new Class[]{String.class},
                new Object[]{model.getModuleId()});
        Map<String, Object> map = JsonUtil.entityToMap(method);
        if (map != null && map.containsKey("formData")) {
            FormDataModel formDataModel = JsonUtil.getJsonToBean(String.valueOf(map.get("formData")),
                    FormDataModel.class);
            List<FieLdsModel> fieLdsModelList = JsonUtil.getJsonToList(formDataModel.getFields(), FieLdsModel.class);
            RecursionForm recursionForm = new RecursionForm();
            recursionForm.setList(fieLdsModelList);
            recursionForm.setTableModelList(JsonUtil.getJsonToList(String.valueOf(map.get("tables")),
                    TableModel.class));
            List<FormAllModel> formAllModel = new ArrayList<>();
            FormCloumnUtil.recursionForm(recursionForm, formAllModel);
            for (FormAllModel allModel : formAllModel) {
                // 子表
                if (FormEnum.table.getMessage().equals(allModel.getKeyName())) {
                    FormColumnTableModel childList = allModel.getChildList();
                    List<FormColumnModel> childList1 = childList.getChildList();
                    for (FormColumnModel formColumnModel : childList1) {
                        FieLdsModel fieLdsModel = formColumnModel.getFieLdsModel();
                        if (StringUtils.isNotEmpty(fieLdsModel.getVModel())) {
                            Map<String, String> map1 = new HashedMap<>();
                            map1.put("field", fieLdsModel.getVModel());
                            map1.put("fieldName", fieLdsModel.getConfig().getLabel());
                            list.add(map1);
                        }
                    }
                } else if (FormEnum.mast.getMessage().equals(allModel.getKeyName())) {
                    FormColumnModel formColumnModel = allModel.getFormColumnModel();
                    FieLdsModel fieLdsModel = formColumnModel.getFieLdsModel();
                    if (StringUtils.isNotEmpty(fieLdsModel.getVModel())) {
                        Map<String, String> map1 = new HashedMap<>();
                        map1.put("field", fieLdsModel.getVModel());
                        map1.put("fieldName", fieLdsModel.getConfig().getLabel());
                        list.add(map1);
                    }
                } else if (FormEnum.mastTable.getMessage().equals(allModel.getKeyName())) {
                    FormMastTableModel formColumnModel = allModel.getFormMastTableModel();
                    FieLdsModel fieLdsModel = formColumnModel.getMastTable().getFieLdsModel();
                    if (StringUtils.isNotEmpty(fieLdsModel.getVModel())) {
                        Map<String, String> map1 = new HashedMap<>();
                        map1.put("field", fieLdsModel.getVModel());
                        map1.put("fieldName", fieLdsModel.getConfig().getLabel());
                        list.add(map1);
                    }
                }
            }
        }
        return ActionResult.success(list);
    }

    /**
     * 获取数据权限配置信息
     *
     * @param id 主键值
     * @return ignore
     * @throws DataException ignore
     */
    @ApiOperation("获取数据权限配置信息")
    @GetMapping("/{id}")
    public ActionResult<DataAuthorizeInfoVO> info(@PathVariable("id") String id) throws DataException {
        ModuleDataAuthorizeEntity entity = dataAuthorizeService.getInfo(id);
        ModuleEntity moduleEntity = moduleService.getInfo(entity.getModuleId());
        if (moduleEntity != null && StringUtils.isNotEmpty(entity.getBindTable())) {
            entity.setEnCode(StringUtils.isNotEmpty(entity.getEnCode()) ?
                    entity.getEnCode().replace(entity.getBindTable() + ".", "") : "");
        }
        DataAuthorizeInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, DataAuthorizeInfoVO.class);
        return ActionResult.success(vo);
    }

    /**
     * 新建数据权限配置
     *
     * @param dataAuthorizeCrForm 实体对象
     * @return ignore
     */
    @ApiOperation("新建数据权限配置")
    @PostMapping
    public ActionResult create(@RequestBody @Valid DataAuthorizeCrForm dataAuthorizeCrForm) {
        ModuleEntity moduleEntity = moduleService.getInfo(dataAuthorizeCrForm.getModuleId());
        ModuleDataAuthorizeEntity entity = JsonUtil.getJsonToBean(dataAuthorizeCrForm, ModuleDataAuthorizeEntity.class);
        entity.setPropertyJson(dataAuthorizeCrForm.getChildTableKey());
        if (moduleEntity != null && moduleEntity.getType() == 3 && entity.getFieldRule() != 0 && StringUtils.isNotEmpty(entity.getBindTable())) {
            String enCode = entity.getBindTable() + "." + entity.getEnCode();
            entity.setEnCode(enCode);
        }
        dataAuthorizeService.create(entity);
        return ActionResult.success(MsgCode.SU001.get());
    }

    /**
     * 更新数据权限配置
     *
     * @param id                  主键值
     * @param dataAuthorizeUpForm 实体对象
     * @return ignore
     */
    @ApiOperation("更新数据权限配置")
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id,
                               @RequestBody @Valid DataAuthorizeUpForm dataAuthorizeUpForm) {
        ModuleEntity moduleEntity = moduleService.getInfo(dataAuthorizeUpForm.getModuleId());
        ModuleDataAuthorizeEntity entity = JsonUtil.getJsonToBean(dataAuthorizeUpForm, ModuleDataAuthorizeEntity.class);
        if (moduleEntity != null && moduleEntity.getType() == 3 && entity.getFieldRule() != 0 && StringUtils.isNotEmpty(entity.getBindTable())) {
            String enCode = entity.getBindTable() + "." + entity.getEnCode();
            entity.setEnCode(enCode);
        }

        entity.setPropertyJson(dataAuthorizeUpForm.getChildTableKey());
        boolean flag = dataAuthorizeService.update(id, entity);
        if (!flag) {
            return ActionResult.success(MsgCode.FA002.get());
        }
        return ActionResult.success(MsgCode.SU004.get());
    }

    /**
     * 删除数据权限配置
     *
     * @param id 主键值
     * @return ignore
     */
    @ApiOperation("删除数据权限配置")
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        ModuleDataAuthorizeEntity entity = dataAuthorizeService.getInfo(id);
        //菜单id
        String moduleId = entity.getModuleId();
        //该菜单下的数据权限方案
        List<ModuleDataAuthorizeSchemeEntity> list = dataAuthorizeSchemeService.getList(moduleId);

        String schemeName = null;
        for (ModuleDataAuthorizeSchemeEntity schemeEntity : list) {
            List<ConditionModel> conditionModels = JsonUtil.getJsonToList(schemeEntity.getConditionJson(),
                    ConditionModel.class);
            if (conditionModels != null) {
                for (ConditionModel conditionModel : conditionModels) {
                    List<ConditionModel.ConditionItemModel> groups = conditionModel.getGroups();
                    for (ConditionModel.ConditionItemModel conditionItemModel : groups) {
                        if (conditionItemModel.getField().equalsIgnoreCase(entity.getEnCode())
                                && conditionItemModel.getBindTable().equalsIgnoreCase(entity.getBindTable())) {
                            schemeName = schemeEntity.getFullName();
                            break;
                        }
                    }
                }
            }
        }
        if (StringUtils.isNotEmpty(schemeName)) {
            return ActionResult.fail("该字段在方案 " + schemeName + " 中已被使用");
        }
        if (entity != null) {
            dataAuthorizeService.delete(entity);
            return ActionResult.success(MsgCode.SU003.get());
        }
        return ActionResult.fail(MsgCode.FA003.get());
    }

}
