package com.bringspring.system.base.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 行政区划
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18m
 */
@Data
@TableName("BASE_PROVINCE")
public class ProvinceEntity {
    /**
     * 区域主键
     */
    @TableId("ID")
    private String id;

    /**
     * 区域上级
     */
    @TableField("PARENT_ID")
    private String parentId;

    /**
     * 区域编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 区域名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 快速查询
     */
    @TableField("QUICK_QUERY")
    private String quickQuery;

    /**
     * 区域类型
     */
    @TableField("TYPE")
    private String type;

    /**
     * 城市级别：0 省份 1 直辖市，2 省会城市 ，3 地级市,4 县区
     */
    @TableField("CITY_LEVEL")
    private Integer cityLevel;

    /**
     * 省份简称
     */
    @TableField("PROV_SIMPLE_NAME")
    private String provSimpleName;

    /**
     * 区域祖宗ids
     */
    @TableField("PARENT_ID_TREE")
    private String parentIdTree;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.INSERT_UPDATE)
    @JSONField(name = "LastModifyTime")
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.INSERT_UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;
}
