package com.bringspring.system.base.model.dblink;

import cn.hutool.json.JSONUtil;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.util.JsonUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.HashMap;
import java.util.Map;

/**
 * 数据库基础表单对象
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class DbLinkBaseForm {

    /**
     * 排序码
     */
    @ApiModelProperty(value = "排序码")
    private long sortCode;

    @ApiModelProperty(value = "连接名")
    @NotBlank(message = "必填")
    private String fullName;

    @ApiModelProperty(value = "数据库类型编码")
    @NotBlank(message = "必填")
    private String dbType;

    @ApiModelProperty(value = "用户")
    @NotBlank(message = "必填")
    private String userName;


    @ApiModelProperty(value = "密码")
    @NotBlank(message = "必填")
    private String password;

    @ApiModelProperty(value = "端口")
    @NotBlank(message = "必填")
    private String port;

    @ApiModelProperty(value = "ip地址")
    @NotBlank(message = "必填")
    private String host;

    @ApiModelProperty(value = "模式")
    private String dbSchema;

    @ApiModelProperty(value = "数据库名")
    private String dbName;

    @ApiModelProperty(value = "表空间")
    private String tableSpace;

    @ApiModelProperty(value = "oracle扩展（true:开启，false:关闭）")
    private Boolean oracleExtend;

    @ApiModelProperty(value = "oracle连接类型")
    private String oracleLinkType;

    @ApiModelProperty(value = "oracle服务名")
    private String oracleService;

    @ApiModelProperty(value = "oracle角色")
    private String oracleRole;



    /**
     * 根据表单对象返回连接实体类
     * @param dbLinkBaseForm 连接表单对象
     * @return 连接实体对象
     */
    public DbLinkEntity getDbLinkEntity(DbLinkBaseForm dbLinkBaseForm){
        DbLinkEntity entity = JsonUtil.getJsonToBean(dbLinkBaseForm, DbLinkEntity.class);
        entity.setDbTableSpace(dbLinkBaseForm.getTableSpace());
        entity.setDbName(dbLinkBaseForm.getDbName());
        Map<String,String> oracleParam = new HashMap<>(16);
        oracleParam.put(DbOracle.ORACLE_LINK_TYPE,dbLinkBaseForm.getOracleLinkType());
        oracleParam.put(DbOracle.ORACLE_SERVICE,dbLinkBaseForm.getOracleService());
        oracleParam.put(DbOracle.ORACLE_ROLE,dbLinkBaseForm.getOracleRole());
        entity.setOracleParam(JSONUtil.toJsonStr(oracleParam));
        return entity;
    }

}
