package com.bringspring.system.base.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.base.entity.ComFieldsEntity;

import java.util.List;

/**
 * 常用字段
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
public interface ComFieldsService extends IService<ComFieldsEntity> {

    /**
     * 获取常用字段列表
     *
     * @return ignore
     */
    List<ComFieldsEntity> getList();

    /**
     * 获取常用字段
     *
     * @param id 主键
     * @return ignore
     */
    ComFieldsEntity getInfo(String id);

    /**
     * 创建常用字段
     *
     * @param entity 实体
     */
    void create(ComFieldsEntity entity);

    /**
     * 修改常用字段
     *
     * @param id     主键
     * @param entity 实体
     * @return ignore
     */
    boolean update(String id, ComFieldsEntity entity);

    /**
     * 验证名称
     *
     * @param fullName 名称
     * @param id       主键值
     * @return ignore
     */
    boolean isExistByFullName(String fullName, String id);

    /**
     * 删除常用字段
     *
     * @param entity 实体
     */
    void delete(ComFieldsEntity entity);
}
